/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.route.internal;

import com.swirlds.common.merkle.exceptions.MerkleRouteException;
import com.swirlds.common.merkle.route.internal.BinaryMerkleRoute;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class BinaryMerkleRouteIterator
implements Iterator<Integer> {
    private int[] routeData;
    private int index;
    private int bitIndex;
    private int stepsInInt;
    private int nextData;
    private Integer next;

    public BinaryMerkleRouteIterator(int[] routeData) {
        this.reset(routeData);
    }

    protected BinaryMerkleRouteIterator() {
    }

    public void reset(int[] route) {
        this.routeData = route;
        this.index = 0;
        this.next = null;
        this.prepareNextInt();
    }

    private void prepareNextInt() {
        if (this.routeData == null) {
            return;
        }
        if (this.routeData.length == 0) {
            return;
        }
        this.nextData = this.routeData[this.index];
        ++this.index;
        if (this.nextData == 0) {
            throw new MerkleRouteException("Routes should not contain 0s.");
        }
        if (this.nextData > 0) {
            this.stepsInInt = 1;
        } else {
            this.stepsInInt = BinaryMerkleRoute.getNumberOfStepsInInt(this.nextData);
            this.bitIndex = 0;
        }
    }

    private void findNext() {
        if (this.next != null) {
            return;
        }
        if (this.routeData == null) {
            return;
        }
        if (this.stepsInInt == 0) {
            if (this.index >= this.routeData.length) {
                return;
            }
            this.prepareNextInt();
        }
        if (this.nextData > 0) {
            this.next = this.nextData;
        } else {
            this.next = BinaryMerkleRoute.getBitAtIndex(this.nextData, this.bitIndex + 1);
            ++this.bitIndex;
        }
        --this.stepsInInt;
    }

    @Override
    public boolean hasNext() {
        this.findNext();
        return this.next != null;
    }

    @Override
    public Integer next() {
        this.findNext();
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Integer ret = this.next;
        this.next = null;
        return ret;
    }
}

