/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.migration;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.demo.migration.MigrationTestingToolTransaction;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.hiero.base.io.streams.SerializableDataInputStream;

public class TransactionUtils {
    private static final byte APPLICATION_TRANSACTION_MARKER = 1;

    @NonNull
    public static MigrationTestingToolTransaction parseTransaction(@NonNull Bytes bytes) {
        Bytes slicedBytes = bytes.slice(1L, bytes.length() - 1L);
        SerializableDataInputStream in = new SerializableDataInputStream(slicedBytes.toInputStream());
        try {
            return (MigrationTestingToolTransaction)in.readSerializable(false, MigrationTestingToolTransaction::new);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not parse transaction kind:%s".formatted(bytes.toHex()), e);
        }
    }

    public static boolean isSystemTransaction(@NonNull Bytes bytes) {
        return bytes.getByte(0L) != 1;
    }
}

