/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.test.fixtures.map.benchmark;

import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.impl.PartialMerkleLeaf;
import com.swirlds.common.merkle.utility.Keyed;
import com.swirlds.merkle.test.fixtures.map.benchmark.BenchmarkKey;
import java.io.IOException;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class BenchmarkAccount
extends PartialMerkleLeaf
implements Keyed<BenchmarkKey>,
MerkleLeaf {
    private static final long CLASS_ID = 7745246644475190861L;
    private long balance;
    private byte[] data;
    private BenchmarkKey key;

    public BenchmarkAccount() {
    }

    public BenchmarkAccount(long balance, byte[] data) {
        this.balance = balance;
        this.data = data;
    }

    protected BenchmarkAccount(BenchmarkAccount that) {
        super((PartialMerkleLeaf)that);
        this.balance = that.balance;
        this.data = that.data;
        this.key = that.key;
    }

    public BenchmarkAccount copy() {
        return new BenchmarkAccount(this);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.balance = in.readLong();
        this.data = in.readByteArray(Integer.MAX_VALUE);
        this.key = (BenchmarkKey)in.readSerializable(false, BenchmarkKey::new);
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.balance);
        out.writeByteArray(this.data);
        out.writeSerializable((SelfSerializable)this.key, false);
    }

    public long getClassId() {
        return 7745246644475190861L;
    }

    public int getVersion() {
        return 1;
    }

    public long getBalance() {
        return this.balance;
    }

    public void setBalance(long balance) {
        this.balance = balance;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public BenchmarkKey getKey() {
        return this.key;
    }

    public void setKey(BenchmarkKey key) {
        this.key = key;
    }
}

