/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.formatting;

import com.swirlds.common.formatting.HorizontalAlignment;
import com.swirlds.common.formatting.StringFormattingUtils;
import com.swirlds.common.formatting.TextEffect;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TextTable {
    private static final char PADDING = ' ';
    private static final char CROSS_JUNCTION = '\u253c';
    private static final char LEFT_JUNCTION = '\u2520';
    private static final char LEFT_HEADER_JUNCTION = '\u2523';
    private static final char RIGHT_JUNCTION = '\u2528';
    private static final char RIGHT_HEADER_JUNCTION = '\u252b';
    private static final char BOTTOM_JUNCTION = '\u2537';
    private static final char TOP_JUNCTION = '\u252f';
    private static final char TOP_LEFT_CORNER = '\u250f';
    private static final char TOP_RIGHT_CORNER = '\u2513';
    private static final char BOTTOM_LEFT_CORNER = '\u2517';
    private static final char BOTTOM_RIGHT_CORNER = '\u251b';
    private static final char HORIZONTAL_BAR = '\u2500';
    private static final char THICK_HORIZONTAL_BAR = '\u2501';
    private static final char VERTICAL_BAR = '\u2502';
    private static final char THICK_VERTICAL_BAR = '\u2503';
    private static final char NEWLINE = '\n';
    private String title;
    private final List<List<String>> rows = new ArrayList<List<String>>();
    private boolean bordersEnabled = true;
    private int extraPadding = 0;
    private final Map<Integer, List<TextEffect>> rowEffects = new HashMap<Integer, List<TextEffect>>();
    private final Map<Integer, List<TextEffect>> columnEffects = new HashMap<Integer, List<TextEffect>>();
    private final Map<Cell, List<TextEffect>> cellEffects = new HashMap<Cell, List<TextEffect>>();
    private final List<TextEffect> titleEffects = new ArrayList<TextEffect>();
    private final List<TextEffect> globalCellEffects = new ArrayList<TextEffect>();
    private final List<TextEffect> borderEffects = new ArrayList<TextEffect>();
    private final Map<Integer, HorizontalAlignment> rowHorizontalAlignments = new HashMap<Integer, HorizontalAlignment>();
    private final Map<Integer, HorizontalAlignment> columnHorizontalAlignments = new HashMap<Integer, HorizontalAlignment>();
    private final Map<Cell, HorizontalAlignment> cellHorizontalAlignments = new HashMap<Cell, HorizontalAlignment>();
    private HorizontalAlignment titleHorizontalAlignment = HorizontalAlignment.ALIGNED_CENTER;
    private HorizontalAlignment globalHorizontalAlignment = HorizontalAlignment.ALIGNED_LEFT;

    @NonNull
    public TextTable setBordersEnabled(boolean bordersEnabled) {
        this.bordersEnabled = bordersEnabled;
        return this;
    }

    @NonNull
    public TextTable setExtraPadding(int extraPadding) {
        this.extraPadding = extraPadding;
        return this;
    }

    @NonNull
    public TextTable setTitle(@NonNull String title) {
        this.title = title;
        return this;
    }

    @NonNull
    public TextTable addRow(Object ... row) {
        if (row != null) {
            ArrayList<String> rowString = new ArrayList<String>();
            for (Object o : row) {
                rowString.add(o == null ? "null" : o.toString());
            }
            this.rows.add(rowString);
        }
        return this;
    }

    @NonNull
    public TextTable addToRow(Object ... elements) {
        List<Object> row;
        if (this.rows.isEmpty()) {
            row = new ArrayList();
            this.rows.add(row);
        } else {
            row = this.rows.get(this.rows.size() - 1);
        }
        for (Object o : elements) {
            row.add(o == null ? "null" : o.toString());
        }
        return this;
    }

    @NonNull
    public TextTable addRowEffects(int row, TextEffect ... effects) {
        if (effects == null) {
            return this;
        }
        List effectList = this.rowEffects.computeIfAbsent(row, k -> new ArrayList());
        effectList.addAll(Arrays.asList(effects));
        return this;
    }

    @NonNull
    public TextTable addColumnEffects(int column, TextEffect ... effects) {
        if (effects == null) {
            return this;
        }
        List effectList = this.columnEffects.computeIfAbsent(column, k -> new ArrayList());
        effectList.addAll(Arrays.asList(effects));
        return this;
    }

    @NonNull
    public TextTable addCellEffects(int row, int column, TextEffect ... effects) {
        if (effects == null) {
            return this;
        }
        Cell cell = new Cell(row, column);
        List effectList = this.cellEffects.computeIfAbsent(cell, k -> new ArrayList());
        effectList.addAll(Arrays.asList(effects));
        return this;
    }

    @NonNull
    public TextTable addTitleEffects(TextEffect ... effects) {
        if (effects == null) {
            return this;
        }
        this.titleEffects.addAll(Arrays.asList(effects));
        return this;
    }

    @NonNull
    public TextTable addGlobalCellEffects(TextEffect ... effects) {
        if (effects == null) {
            return this;
        }
        this.globalCellEffects.addAll(Arrays.asList(effects));
        return this;
    }

    @NonNull
    public TextTable addBorderEffects(TextEffect ... effects) {
        if (effects == null) {
            return this;
        }
        this.borderEffects.addAll(Arrays.asList(effects));
        return this;
    }

    @NonNull
    public TextTable setRowHorizontalAlignment(int row, @NonNull HorizontalAlignment alignment) {
        Objects.requireNonNull(alignment, "alignment must not be null");
        this.rowHorizontalAlignments.put(row, alignment);
        return this;
    }

    @NonNull
    public TextTable setColumnHorizontalAlignment(int column, @NonNull HorizontalAlignment alignment) {
        Objects.requireNonNull(alignment, "alignment must not be null");
        this.columnHorizontalAlignments.put(column, alignment);
        return this;
    }

    @NonNull
    public TextTable setCellHorizontalAlignment(int row, int column, @NonNull HorizontalAlignment alignment) {
        Objects.requireNonNull(alignment, "alignment must not be null");
        this.cellHorizontalAlignments.put(new Cell(row, column), alignment);
        return this;
    }

    @NonNull
    public TextTable setTitleHorizontalAlignment(@NonNull HorizontalAlignment alignment) {
        Objects.requireNonNull(alignment, "alignment must not be null");
        this.titleHorizontalAlignment = alignment;
        return this;
    }

    @NonNull
    public TextTable setGlobalHorizontalAlignment(@NonNull HorizontalAlignment alignment) {
        Objects.requireNonNull(alignment, "alignment must not be null");
        this.globalHorizontalAlignment = alignment;
        return this;
    }

    @NonNull
    private String formatCellData(int row, int column, @NonNull String cellData) {
        Cell cell;
        ArrayList<TextEffect> effects = new ArrayList<TextEffect>(this.globalCellEffects);
        if (this.rowEffects.containsKey(row)) {
            effects.addAll((Collection<TextEffect>)this.rowEffects.get(row));
        }
        if (this.columnEffects.containsKey(column)) {
            effects.addAll((Collection<TextEffect>)this.columnEffects.get(column));
        }
        if (this.cellEffects.containsKey(cell = new Cell(row, column))) {
            effects.addAll((Collection<TextEffect>)this.cellEffects.get(cell));
        }
        if (effects.isEmpty()) {
            return cellData;
        }
        return TextEffect.applyEffects(cellData, effects);
    }

    private void alignCellData(@NonNull StringBuilder sb, int row, int column, @NonNull String cellData, int desiredWidth, boolean isLastColumn) {
        Cell cell = new Cell(row, column);
        HorizontalAlignment alignment = this.cellHorizontalAlignments.containsKey(cell) ? this.cellHorizontalAlignments.get(cell) : (this.columnHorizontalAlignments.containsKey(column) ? this.columnHorizontalAlignments.get(column) : (this.rowHorizontalAlignments.containsKey(row) ? this.rowHorizontalAlignments.get(row) : this.globalHorizontalAlignment));
        boolean trailingPadding = this.bordersEnabled || !isLastColumn;
        alignment.pad(sb, cellData, ' ', desiredWidth, trailingPadding);
    }

    private void writeBorder(@NonNull StringBuilder sb, @NonNull String border) {
        if (this.borderEffects.isEmpty()) {
            sb.append(border);
        } else {
            TextEffect.applyEffects(sb, border, this.borderEffects);
        }
    }

    private void writeBorder(@NonNull StringBuilder sb, char border) {
        this.writeBorder(sb, String.valueOf(border));
    }

    private static void expandColumnWidthsForRow(@NonNull List<Integer> columnWidths, @NonNull List<String> row) {
        for (int column = 0; column < row.size(); ++column) {
            int columnWidth = TextEffect.getPrintableTextLength(row.get(column));
            if (columnWidths.size() <= column) {
                columnWidths.add(columnWidth);
                continue;
            }
            columnWidths.set(column, Math.max(columnWidths.get(column), columnWidth));
        }
    }

    private List<Integer> computeColumnWidths() {
        ArrayList<Integer> columnWidths = new ArrayList<Integer>();
        for (List<String> row : this.rows) {
            TextTable.expandColumnWidthsForRow(columnWidths, row);
        }
        return columnWidths;
    }

    private void generateTopLine(@NonNull StringBuilder sb, @NonNull List<Integer> columnWidths, int columnWidthSum) {
        if (!this.bordersEnabled) {
            return;
        }
        this.writeBorder(sb, '\u250f');
        if (this.title != null) {
            this.writeBorder(sb, StringFormattingUtils.repeatedChar('\u2501', columnWidthSum + columnWidths.size() * 3 - 1));
        } else {
            for (int columnIndex = 0; columnIndex < columnWidths.size(); ++columnIndex) {
                this.writeBorder(sb, StringFormattingUtils.repeatedChar('\u2501', columnWidths.get(columnIndex) + 2 + this.extraPadding));
                if (columnIndex + 1 >= columnWidths.size()) continue;
                this.writeBorder(sb, '\u252f');
            }
        }
        this.writeBorder(sb, '\u2513');
        sb.append('\n');
    }

    private void generateTitleLine(@NonNull StringBuilder sb, int columnWidthSum, int columnCount) {
        if (this.title == null) {
            return;
        }
        if (this.bordersEnabled) {
            this.writeBorder(sb, '\u2503');
            sb.append(' ');
        }
        String formattedTitle = TextEffect.applyEffects(this.title, this.titleEffects);
        int titleWidth = this.bordersEnabled ? columnWidthSum + columnCount * 3 - 3 : columnWidthSum + columnCount * 3 - 1;
        this.titleHorizontalAlignment.pad(sb, formattedTitle, ' ', titleWidth, this.bordersEnabled);
        if (this.bordersEnabled) {
            sb.append(' ');
            this.writeBorder(sb, '\u2503');
            sb.append('\n');
        }
    }

    private void generateLineBelowTitle(@NonNull StringBuilder sb, @NonNull List<Integer> columnWidths) {
        if (this.title == null || !this.bordersEnabled) {
            return;
        }
        this.writeBorder(sb, '\u2523');
        for (int columnIndex = 0; columnIndex < columnWidths.size(); ++columnIndex) {
            this.writeBorder(sb, StringFormattingUtils.repeatedChar('\u2501', columnWidths.get(columnIndex) + 2 + this.extraPadding));
            if (columnIndex + 1 >= columnWidths.size()) continue;
            this.writeBorder(sb, '\u252f');
        }
        this.writeBorder(sb, '\u252b');
        sb.append('\n');
    }

    private void generateDataRow(@NonNull StringBuilder sb, int row, @NonNull List<Integer> columnWidths) {
        List<String> rowData = this.rows.get(row);
        if (this.bordersEnabled) {
            this.writeBorder(sb, '\u2503');
        }
        for (int column = 0; column < columnWidths.size(); ++column) {
            if (this.bordersEnabled) {
                sb.append(' ');
            }
            String cellData = column < rowData.size() ? rowData.get(column) : "";
            String formattedCellData = this.formatCellData(row, column, cellData);
            boolean isLastColumn = column == columnWidths.size() - 1;
            this.alignCellData(sb, row, column, formattedCellData, columnWidths.get(column), isLastColumn);
            if (this.bordersEnabled || !isLastColumn) {
                sb.append(StringFormattingUtils.repeatedChar(' ', this.extraPadding + 1));
            }
            if (!this.bordersEnabled || column + 1 >= columnWidths.size()) continue;
            this.writeBorder(sb, '\u2502');
        }
        if (this.bordersEnabled) {
            this.writeBorder(sb, '\u2503');
        }
        sb.append('\n');
    }

    private void generateLineBelowDataRow(@NonNull StringBuilder sb, @NonNull List<Integer> columnWidths) {
        if (!this.bordersEnabled) {
            return;
        }
        this.writeBorder(sb, '\u2520');
        for (int columnIndex = 0; columnIndex < columnWidths.size(); ++columnIndex) {
            this.writeBorder(sb, StringFormattingUtils.repeatedChar('\u2500', columnWidths.get(columnIndex) + 2 + this.extraPadding));
            if (columnIndex + 1 >= columnWidths.size()) continue;
            this.writeBorder(sb, '\u253c');
        }
        this.writeBorder(sb, '\u2528');
        sb.append('\n');
    }

    private void generateRows(@NonNull StringBuilder sb, @NonNull List<Integer> columnWidths) {
        for (int row = 0; row < this.rows.size(); ++row) {
            this.generateDataRow(sb, row, columnWidths);
            if (row + 1 >= this.rows.size()) continue;
            this.generateLineBelowDataRow(sb, columnWidths);
        }
    }

    private void generateBottomLine(@NonNull StringBuilder sb, @NonNull List<Integer> columnWidths) {
        if (!this.bordersEnabled) {
            return;
        }
        this.writeBorder(sb, '\u2517');
        for (int columnIndex = 0; columnIndex < columnWidths.size(); ++columnIndex) {
            this.writeBorder(sb, StringFormattingUtils.repeatedChar('\u2501', columnWidths.get(columnIndex) + 2 + this.extraPadding));
            if (columnIndex + 1 >= columnWidths.size()) continue;
            this.writeBorder(sb, '\u2537');
        }
        this.writeBorder(sb, '\u251b');
    }

    private void expandLastColumnIfNeeded(@NonNull List<Integer> columnWidths) {
        if (this.title == null) {
            return;
        }
        int columnWidthSum = 0;
        for (int columnWidth : columnWidths) {
            columnWidthSum += columnWidth;
        }
        int titleLength = TextEffect.getPrintableTextLength(this.title);
        int minimumWidth = titleLength + columnWidths.size() * 3 - 3;
        if (columnWidthSum < minimumWidth) {
            int expansion = minimumWidth - columnWidthSum;
            int lastIndex = columnWidths.size() - 1;
            columnWidths.set(lastIndex, columnWidths.get(lastIndex) + expansion);
        }
    }

    public void render(@NonNull StringBuilder sb) {
        List<Integer> columnWidths = this.computeColumnWidths();
        this.expandLastColumnIfNeeded(columnWidths);
        int columnWidthSum = 0;
        for (int columnWidth : columnWidths) {
            columnWidthSum += columnWidth + this.extraPadding;
        }
        this.generateTopLine(sb, columnWidths, columnWidthSum);
        this.generateTitleLine(sb, columnWidthSum, columnWidths.size());
        this.generateLineBelowTitle(sb, columnWidths);
        this.generateRows(sb, columnWidths);
        this.generateBottomLine(sb, columnWidths);
    }

    @NonNull
    public String render() {
        StringBuilder sb = new StringBuilder();
        this.render(sb);
        return sb.toString();
    }

    @NonNull
    public String toString() {
        return this.render();
    }

    private record Cell(int row, int column) {
    }
}

