/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.preconsensus;

import com.swirlds.common.formatting.StringFormattingUtils;
import com.swirlds.common.io.utility.RecycleBin;
import com.swirlds.platform.event.preconsensus.PcesFileIterator;
import com.swirlds.platform.event.preconsensus.PcesFileWriterType;
import com.swirlds.platform.event.preconsensus.PcesMutableFile;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import java.util.stream.Stream;
import org.hiero.base.utility.NonCryptographicHashing;

public final class PcesFile
implements Comparable<PcesFile> {
    public static final String EVENT_FILE_EXTENSION = ".pces";
    public static final String EVENT_FILE_SEPARATOR = "_";
    public static final String SEQUENCE_NUMBER_PREFIX = "seq";
    public static final String MINIMUM_BIRTH_ROUND_PREFIX = "minr";
    public static final String MAXIMUM_BIRTH_ROUND_PREFIX = "maxr";
    public static final String ORIGIN_PREFIX = "orgn";
    private static final int STRING_BUILDER_INITIAL_CAPACITY = 128;
    private final long sequenceNumber;
    private final long lowerBound;
    private final long upperBound;
    private final long origin;
    private final Instant timestamp;
    private final Path path;

    private PcesFile(@NonNull Instant timestamp, long sequenceNumber, long lowerBound, long upperBound, long origin, @NonNull Path path) {
        if (sequenceNumber < 0L) {
            throw new IllegalArgumentException("sequence number " + lowerBound + " is negative");
        }
        if (lowerBound < 0L) {
            throw new IllegalArgumentException("lower bound " + lowerBound + " is negative");
        }
        if (upperBound < 0L) {
            throw new IllegalArgumentException("upper bound " + upperBound + " is negative");
        }
        if (origin < 0L) {
            throw new IllegalArgumentException("origin " + origin + " is negative");
        }
        if (upperBound < lowerBound) {
            throw new IllegalArgumentException("upper bound " + upperBound + " is less than the lower bound " + lowerBound);
        }
        this.sequenceNumber = sequenceNumber;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.origin = origin;
        this.timestamp = Objects.requireNonNull(timestamp);
        this.path = Objects.requireNonNull(path);
    }

    @NonNull
    public static PcesFile of(@NonNull Instant timestamp, long sequenceNumber, long minimumBound, long maximumBound, long origin, @NonNull Path rootDirectory) {
        Path parentDirectory = PcesFile.buildParentDirectory(rootDirectory, timestamp);
        String fileName = PcesFile.buildFileName(timestamp, sequenceNumber, minimumBound, maximumBound, origin);
        Path path = parentDirectory.resolve(fileName);
        return new PcesFile(timestamp, sequenceNumber, minimumBound, maximumBound, origin, path);
    }

    @NonNull
    public static PcesFile of(@NonNull Path filePath) throws IOException {
        Objects.requireNonNull(filePath, "filePath");
        if (!filePath.toString().endsWith(EVENT_FILE_EXTENSION)) {
            throw new IOException("File " + String.valueOf(filePath) + " has the wrong type");
        }
        String fileName = filePath.getFileName().toString();
        String[] elements = fileName.substring(0, fileName.length() - EVENT_FILE_EXTENSION.length()).split(EVENT_FILE_SEPARATOR);
        if (elements.length != 5) {
            throw new IOException("Unable to parse fields from " + String.valueOf(filePath));
        }
        try {
            return new PcesFile(StringFormattingUtils.parseSanitizedTimestamp((String)elements[0]), Long.parseLong(elements[1].replace(SEQUENCE_NUMBER_PREFIX, "")), Long.parseLong(elements[2].replace(MINIMUM_BIRTH_ROUND_PREFIX, "")), Long.parseLong(elements[3].replace(MAXIMUM_BIRTH_ROUND_PREFIX, "")), Long.parseLong(elements[4].replace(ORIGIN_PREFIX, "")), filePath);
        }
        catch (IllegalArgumentException | DateTimeParseException ex) {
            throw new IOException("unable to parse " + String.valueOf(filePath), ex);
        }
    }

    @NonNull
    public PcesFile buildFileWithCompressedSpan(long maximumBoundaryValueInFile) {
        if (maximumBoundaryValueInFile < this.lowerBound) {
            throw new IllegalArgumentException("maximumBoundaryValueInFile " + maximumBoundaryValueInFile + " is less than lowerBound " + this.lowerBound);
        }
        if (maximumBoundaryValueInFile > this.upperBound) {
            throw new IllegalArgumentException("maximumBoundaryValueInFile " + maximumBoundaryValueInFile + " is greater than upperBound " + this.upperBound);
        }
        Path parentDirectory = this.path.getParent();
        String fileName = PcesFile.buildFileName(this.timestamp, this.sequenceNumber, this.lowerBound, maximumBoundaryValueInFile, this.origin);
        Path newPath = parentDirectory.resolve(fileName);
        return new PcesFile(this.timestamp, this.sequenceNumber, this.lowerBound, maximumBoundaryValueInFile, this.origin, newPath);
    }

    @NonNull
    public Instant getTimestamp() {
        return this.timestamp;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getLowerBound() {
        return this.lowerBound;
    }

    public long getUpperBound() {
        return this.upperBound;
    }

    public long getOrigin() {
        return this.origin;
    }

    @NonNull
    public Path getPath() {
        return this.path;
    }

    @NonNull
    public PcesMutableFile getMutableFile(@NonNull PcesFileWriterType pcesFileWriterType) throws IOException {
        return new PcesMutableFile(this, pcesFileWriterType);
    }

    public void deleteFile(@NonNull Path rootDirectory) throws IOException {
        this.deleteFile(rootDirectory, null);
    }

    public void deleteFile(@NonNull Path rootDirectory, @Nullable RecycleBin recycleBin) throws IOException {
        if (!Files.exists(this.path, new LinkOption[0])) {
            return;
        }
        if (recycleBin == null) {
            Files.delete(this.path);
        } else {
            recycleBin.recycle(this.path);
        }
        Path target = this.path.getParent();
        while (!target.equals(rootDirectory)) {
            try (Stream<Path> list = Files.list(target);){
                if (list.findAny().isPresent()) {
                    return;
                }
            }
            Files.delete(target);
            target = target.getParent();
        }
    }

    @NonNull
    public PcesFileIterator iterator(long lowerBound) throws IOException {
        return new PcesFileIterator(this, lowerBound);
    }

    @NonNull
    private static Path buildParentDirectory(@NonNull Path rootDirectory, @NonNull Instant timestamp) {
        ZonedDateTime zonedDateTime = timestamp.atZone(ZoneId.systemDefault());
        return rootDirectory.resolve(String.format("%04d", zonedDateTime.getYear())).resolve(String.format("%02d", zonedDateTime.getMonthValue())).resolve(String.format("%02d", zonedDateTime.getDayOfMonth()));
    }

    @NonNull
    private static String buildFileName(@NonNull Instant timestamp, long sequenceNumber, long minimumBound, long maximumBound, long origin) {
        return new StringBuilder(128).append(StringFormattingUtils.sanitizeTimestamp((Instant)timestamp)).append(EVENT_FILE_SEPARATOR).append(SEQUENCE_NUMBER_PREFIX).append(sequenceNumber).append(EVENT_FILE_SEPARATOR).append(MINIMUM_BIRTH_ROUND_PREFIX).append(minimumBound).append(EVENT_FILE_SEPARATOR).append(MAXIMUM_BIRTH_ROUND_PREFIX).append(maximumBound).append(EVENT_FILE_SEPARATOR).append(ORIGIN_PREFIX).append(origin).append(EVENT_FILE_EXTENSION).toString();
    }

    @NonNull
    public String getFileName() {
        return this.path.getFileName().toString();
    }

    public boolean canContain(long eventSequenceNumber) {
        return eventSequenceNumber >= this.lowerBound && eventSequenceNumber <= this.upperBound;
    }

    @Override
    public int compareTo(@NonNull PcesFile that) {
        return Long.compare(this.sequenceNumber, that.sequenceNumber);
    }

    public String toString() {
        return this.getFileName();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PcesFile) {
            PcesFile that = (PcesFile)obj;
            return this.sequenceNumber == that.sequenceNumber;
        }
        return false;
    }

    public int hashCode() {
        return NonCryptographicHashing.hash32((long)this.sequenceNumber);
    }
}

