/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.health.entropy;

import com.swirlds.platform.health.OSHealthCheckUtils;
import com.swirlds.platform.health.entropy.EntropySource;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.function.Supplier;

public final class OSEntropyCheck {
    private static final long DEFAULT_RANDOM_TIMEOUT_MILLIS = 100L;
    private static final String DEFAULT_NUMBER_GENERATION_ALGORITHM = "NativePRNGBlocking";
    private static final String DEFAULT_NUMBER_GENERATION_PROVIDER = "SUN";

    private OSEntropyCheck() {
    }

    public static Report execute() throws InterruptedException {
        return OSEntropyCheck.execute(100L);
    }

    public static Report execute(long timeoutMillis) throws InterruptedException {
        return OSEntropyCheck.execute(timeoutMillis, EntropySource.of(DEFAULT_NUMBER_GENERATION_ALGORITHM, DEFAULT_NUMBER_GENERATION_PROVIDER));
    }

    public static Report execute(long timeoutMillis, EntropySource entropySource) throws InterruptedException {
        SecureRandom random;
        try {
            random = entropySource.randomSupplier().get();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            return Report.failure(entropySource.description(), e);
        }
        Supplier<Long> randomRequester = random::nextLong;
        OSHealthCheckUtils.SupplierResult<Long> result = OSHealthCheckUtils.timeSupplier(randomRequester, timeoutMillis);
        if (result == null) {
            return Report.failure(entropySource.description());
        }
        long elapsedNanos = result.duration().toNanos();
        Long randomLong = result.result();
        return Report.success(entropySource.description(), elapsedNanos, randomLong);
    }

    public record Report(boolean success, String entropySource, Long elapsedNanos, Long randomLong, Exception exception) {
        private static final String NAME = "Entropy Check";

        public static Report failure(String entropySource) {
            return Report.failure(entropySource, null);
        }

        public static Report failure(String entropySource, Exception e) {
            return new Report(false, entropySource, null, null, e);
        }

        public static Report success(String entropySource, long elapsedNanos, Long randomLong) {
            return new Report(true, entropySource, elapsedNanos, randomLong, null);
        }

        public static String name() {
            return NAME;
        }
    }
}

