/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.io.streams;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.hiero.base.io.FunctionalSerialize;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.SerializableDet;
import org.hiero.base.io.SerializableWithKnownLength;
import org.hiero.base.io.streams.AugmentedDataOutputStream;

public class SerializableDataOutputStream
extends AugmentedDataOutputStream {
    private final WritableSequentialData writableSequentialData;

    public SerializableDataOutputStream(@NonNull OutputStream out) {
        super(out);
        this.writableSequentialData = new WritableStreamingData(out);
    }

    public void writeProtocolVersion() throws IOException {
        this.writeInt(1);
    }

    private void writeSerializable(@Nullable SelfSerializable serializable, boolean writeClassId, @NonNull FunctionalSerialize serializeMethod) throws IOException {
        if (serializable == null) {
            if (writeClassId) {
                this.writeLong(Long.MIN_VALUE);
            } else {
                this.writeInt(Integer.MIN_VALUE);
            }
            return;
        }
        this.writeClassIdVersion(serializable, writeClassId);
        serializeMethod.serialize(this);
    }

    public void writeSerializable(@NonNull SelfSerializable serializable, boolean writeClassId) throws IOException {
        this.writeSerializable(serializable, writeClassId, serializable);
    }

    public <T extends SelfSerializable> void writeSerializableIterableWithSize(@NonNull Iterator<T> iterator, int size, boolean writeClassId, boolean allSameClass) throws IOException {
        this.writeInt(size);
        if (size == 0) {
            return;
        }
        this.writeBoolean(allSameClass);
        boolean classIdVersionWritten = false;
        while (iterator.hasNext()) {
            SelfSerializable serializable = (SelfSerializable)iterator.next();
            if (!allSameClass) {
                this.writeSerializable(serializable, writeClassId);
                continue;
            }
            if (serializable == null) {
                this.writeBoolean(true);
                continue;
            }
            this.writeBoolean(false);
            if (!classIdVersionWritten) {
                this.writeClassIdVersion(serializable, writeClassId);
                classIdVersionWritten = true;
            }
            serializable.serialize(this);
        }
    }

    public <T extends SelfSerializable> void writeSerializableList(@Nullable List<T> list, boolean writeClassId, boolean allSameClass) throws IOException {
        if (list == null) {
            this.writeInt(-1);
            return;
        }
        this.writeSerializableIterableWithSize(list.iterator(), list.size(), writeClassId, allSameClass);
    }

    public <T extends SelfSerializable> void writeSerializableArray(@Nullable T[] array, boolean writeClassId, boolean allSameClass) throws IOException {
        if (array == null) {
            this.writeSerializableList(null, writeClassId, allSameClass);
        } else {
            this.writeSerializableList(Arrays.asList(array), writeClassId, allSameClass);
        }
    }

    public static <T extends SerializableWithKnownLength> int getSerializedLength(@Nullable T[] array, boolean writeClassId, boolean allSameClass) {
        int totalByteLength = 4;
        if (array == null || array.length == 0) {
            return totalByteLength;
        }
        ++totalByteLength;
        boolean classIdVersionWritten = false;
        for (T t : array) {
            if (!allSameClass) {
                totalByteLength += SerializableDataOutputStream.getInstanceSerializedLength(t, true, writeClassId);
                continue;
            }
            if (t == null) {
                ++totalByteLength;
                continue;
            }
            ++totalByteLength;
            if (!classIdVersionWritten) {
                totalByteLength += 4;
                if (writeClassId) {
                    totalByteLength += 8;
                }
                classIdVersionWritten = true;
            }
            totalByteLength += SerializableDataOutputStream.getInstanceSerializedLength(t, false, false);
        }
        return totalByteLength;
    }

    public static <T extends SerializableWithKnownLength> int getInstanceSerializedLength(@Nullable T data, boolean writeVersion, boolean writeClassId) {
        if (data == null) {
            return writeClassId ? 8 : (writeVersion ? 4 : 0);
        }
        int totalByteLength = 0;
        if (writeClassId) {
            totalByteLength += 8;
        }
        if (writeVersion) {
            totalByteLength += 4;
        }
        return totalByteLength += data.getSerializedLength();
    }

    protected void writeClassIdVersion(@NonNull SerializableDet serializable, boolean writeClassId) throws IOException {
        if (writeClassId) {
            this.writeLong(serializable.getClassId());
        }
        this.writeInt(serializable.getVersion());
    }

    public <T> long writePbjRecord(@NonNull T record, @NonNull Codec<T> codec) throws IOException {
        int recordSize = codec.measureRecord(record);
        this.writeInt(recordSize);
        codec.write(record, this.writableSequentialData);
        return recordSize + 4;
    }
}

