/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.addressbook;

import com.swirlds.platform.test.fixtures.crypto.PreGeneratedX509Certs;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Random;
import org.hiero.base.utility.test.fixtures.RandomUtils;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.Address;
import org.hiero.consensus.model.roster.SerializableX509Certificate;

public class RandomAddressBuilder {
    private final Random random;
    private NodeId nodeId;
    private Long weight;
    private Integer port;
    private String hostname;
    private SerializableX509Certificate sigCert;
    private SerializableX509Certificate agreeCert;
    private long minimumWeight = 0L;
    private long maximumWeight = 0x1FFFFFFFFFFFFFL;

    @NonNull
    public static RandomAddressBuilder create(@NonNull Random random) {
        return new RandomAddressBuilder(random);
    }

    private RandomAddressBuilder(@NonNull Random random) {
        this.random = Objects.requireNonNull(random);
    }

    @NonNull
    public Address build() {
        if (this.nodeId == null) {
            this.nodeId = NodeId.of((long)this.random.nextLong(0L, Long.MAX_VALUE));
        }
        if (this.weight == null) {
            this.weight = this.random.nextLong(this.minimumWeight, this.maximumWeight);
        }
        if (this.port == null) {
            this.port = this.random.nextInt(1, 65535);
        }
        if (this.hostname == null) {
            this.hostname = RandomUtils.randomIp((Random)this.random);
        }
        if (this.sigCert == null) {
            this.sigCert = PreGeneratedX509Certs.getSigCert(this.nodeId.id());
        }
        if (this.agreeCert == null) {
            this.agreeCert = PreGeneratedX509Certs.getAgreeCert(this.nodeId.id());
        }
        return new Address(this.nodeId, RandomUtils.randomString((Random)this.random, (int)8), RandomUtils.randomString((Random)this.random, (int)8), this.weight.longValue(), this.hostname, this.port.intValue(), this.hostname, this.port.intValue(), this.sigCert, this.agreeCert, RandomUtils.randomString((Random)this.random, (int)8));
    }

    @NonNull
    public RandomAddressBuilder withNodeId(@NonNull NodeId nodeId) {
        this.nodeId = Objects.requireNonNull(nodeId);
        return this;
    }

    @NonNull
    public RandomAddressBuilder withWeight(long weight) {
        this.weight = weight;
        return this;
    }

    @NonNull
    public RandomAddressBuilder withPort(int port) {
        this.port = port;
        return this;
    }

    @NonNull
    public RandomAddressBuilder withHostname(@NonNull String hostname) {
        this.hostname = Objects.requireNonNull(hostname);
        return this;
    }

    @NonNull
    public RandomAddressBuilder withSigCert(@NonNull SerializableX509Certificate sigCert) {
        this.sigCert = Objects.requireNonNull(sigCert);
        return this;
    }

    @NonNull
    public RandomAddressBuilder withAgreeCert(@NonNull SerializableX509Certificate agreeCert) {
        this.agreeCert = Objects.requireNonNull(agreeCert);
        return this;
    }

    @NonNull
    public RandomAddressBuilder withMinimumWeight(long minimumWeight) {
        this.minimumWeight = minimumWeight;
        return this;
    }

    @NonNull
    public RandomAddressBuilder withMaximumWeight(long maximumWeight) {
        this.maximumWeight = maximumWeight;
        return this;
    }
}

