/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.roster;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RoundRosterPair;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Map;

public class RosterHistory {
    private final List<RoundRosterPair> history;
    private final Map<Bytes, Roster> rosters;

    public RosterHistory(@NonNull List<RoundRosterPair> history, @NonNull Map<Bytes, Roster> rosters) {
        this.history = history;
        this.rosters = rosters;
        if (history.isEmpty()) {
            throw new IllegalArgumentException("Roster history is empty");
        }
        if (history.stream().map(RoundRosterPair::activeRosterHash).anyMatch(hash -> !rosters.containsKey(hash))) {
            throw new IllegalArgumentException("Roster history refers to roster hashes not found in the roster map: history: " + String.valueOf(history) + ", rosters: " + String.valueOf(rosters));
        }
    }

    @NonNull
    public Roster getCurrentRoster() {
        return this.rosters.get(this.history.getFirst().activeRosterHash());
    }

    @NonNull
    public Roster getPreviousRoster() {
        return this.rosters.get(this.history.get(this.history.size() > 1 ? 1 : 0).activeRosterHash());
    }

    @Nullable
    public Roster getRosterForRound(long roundNumber) {
        for (RoundRosterPair roundRosterPair : this.history) {
            if (roundRosterPair.roundNumber() > roundNumber) continue;
            return this.rosters.get(roundRosterPair.activeRosterHash());
        }
        return null;
    }

    @NonNull
    public String toString() {
        boolean previousExists = this.history.size() > 1;
        StringBuilder sb = new StringBuilder();
        sb.append("RosterHistory[ currentRosterRound: ").append(this.history.getFirst().roundNumber()).append(" ][ ");
        if (previousExists) {
            sb.append("previousRosterRound: ").append(this.history.get(1).roundNumber());
        } else {
            sb.append("no previous roster set");
        }
        sb.append(" ]\nCurrent Roster: ").append(Roster.JSON.toJSON((Object)this.getCurrentRoster()));
        if (previousExists) {
            sb.append("\nPrevious Roster: ").append(Roster.JSON.toJSON((Object)this.getPreviousRoster()));
        }
        return sb.toString();
    }
}

