/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.test.fixtures;

import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableKVStateBase;
import com.swirlds.state.spi.WritableQueueState;
import com.swirlds.state.spi.WritableQueueStateBase;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableSingletonStateBase;
import com.swirlds.state.spi.WritableStates;
import com.swirlds.state.test.fixtures.MapWritableKVState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MapWritableStates
implements WritableStates,
CommittableWritableStates {
    private final Map<String, ?> states;
    @Nullable
    private final Runnable onCommit;

    public MapWritableStates(@NonNull Map<String, ?> states) {
        this(states, null);
    }

    public MapWritableStates(@NonNull Map<String, ?> states, @Nullable Runnable onCommit) {
        this.states = Objects.requireNonNull(states);
        this.onCommit = onCommit;
    }

    @NonNull
    public <K, V> WritableKVState<K, V> get(@NonNull String stateKey) {
        Object state = this.states.get(Objects.requireNonNull(stateKey));
        if (state == null) {
            throw new IllegalArgumentException("Unknown k/v state key " + stateKey);
        }
        return (WritableKVState)state;
    }

    @NonNull
    public <T> WritableSingletonState<T> getSingleton(@NonNull String stateKey) {
        Object state = this.states.get(Objects.requireNonNull(stateKey));
        if (state == null) {
            throw new IllegalArgumentException("Unknown singleton state key " + stateKey);
        }
        return (WritableSingletonState)state;
    }

    @NonNull
    public <E> WritableQueueState<E> getQueue(@NonNull String stateKey) {
        Object state = this.states.get(Objects.requireNonNull(stateKey));
        if (state == null) {
            throw new IllegalArgumentException("Unknown queue state key " + stateKey);
        }
        return (WritableQueueState)state;
    }

    public boolean contains(@NonNull String stateKey) {
        return this.states.containsKey(stateKey);
    }

    @NonNull
    public Set<String> stateKeys() {
        return Collections.unmodifiableSet(this.states.keySet());
    }

    public int size() {
        return this.states.size();
    }

    public void commit() {
        this.states.values().forEach(state -> {
            if (state instanceof WritableKVStateBase) {
                WritableKVStateBase kv = (WritableKVStateBase)state;
                kv.commit();
            } else if (state instanceof WritableSingletonStateBase) {
                WritableSingletonStateBase singleton = (WritableSingletonStateBase)state;
                singleton.commit();
            } else if (state instanceof WritableQueueStateBase) {
                WritableQueueStateBase queue = (WritableQueueStateBase)state;
                queue.commit();
            } else {
                throw new IllegalStateException("Unknown state type " + state.getClass().getName());
            }
        });
        if (this.onCommit != null) {
            this.onCommit.run();
        }
    }

    public String toString() {
        return "MapWritableStates{states=" + String.valueOf(this.states) + "}";
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> states = new HashMap<String, Object>();

        @NonNull
        public Builder state(@NonNull MapWritableKVState state) {
            this.states.put(state.getStateKey(), (Object)state);
            return this;
        }

        @NonNull
        public Builder state(@NonNull WritableSingletonState<?> state) {
            this.states.put(state.getStateKey(), state);
            return this;
        }

        @NonNull
        public Builder state(@NonNull WritableQueueState<?> state) {
            this.states.put(state.getStateKey(), state);
            return this;
        }

        @NonNull
        public MapWritableStates build() {
            return new MapWritableStates(new HashMap<String, Object>(this.states));
        }
    }
}

