/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.test.fixtures.map.lifecycle;

import com.swirlds.merkle.test.fixtures.map.lifecycle.TransactionState;
import com.swirlds.merkle.test.fixtures.map.lifecycle.TransactionType;
import java.io.Serializable;
import java.util.Objects;

public class LifecycleStatus
implements Serializable {
    private TransactionState transactionState;
    private TransactionType transactionType;
    private long timestamp;
    private long nodeId;

    public LifecycleStatus(TransactionState transactionState, TransactionType transactionType, long timestamp, long nodeId) {
        this.transactionState = transactionState;
        this.transactionType = transactionType;
        this.timestamp = timestamp;
        this.nodeId = nodeId;
    }

    public LifecycleStatus() {
    }

    private LifecycleStatus(Builder builder) {
        this.transactionState = builder.transactionState;
        this.transactionType = builder.transactionType;
        this.timestamp = builder.timestamp;
        this.nodeId = builder.nodeId;
    }

    public TransactionState getTransactionState() {
        return this.transactionState;
    }

    public LifecycleStatus setTransactionState(TransactionState transactionState) {
        this.transactionState = transactionState;
        return this;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public LifecycleStatus setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public LifecycleStatus setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public LifecycleStatus setNodeId(long nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public String toString() {
        return String.format("TransactionState: %s, TransactionType: %s, timestamp: %d, nodeId: %d", new Object[]{this.transactionState, this.transactionType, this.timestamp, this.nodeId});
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transactionState, this.transactionType, this.timestamp, this.nodeId});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof LifecycleStatus) {
            LifecycleStatus that = (LifecycleStatus)object;
            return this.transactionState.equals((Object)that.transactionState) && this.transactionType.equals((Object)that.transactionType) && this.timestamp == that.timestamp && this.nodeId == that.nodeId;
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TransactionState transactionState;
        private TransactionType transactionType;
        private long timestamp;
        private long nodeId = -1L;

        private Builder() {
        }

        public Builder setTransactionState(TransactionState transactionState) {
            this.transactionState = transactionState;
            return this;
        }

        public Builder setTransactionType(TransactionType transactionType) {
            this.transactionType = transactionType;
            return this;
        }

        public Builder setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setNodeId(long nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public LifecycleStatus build() {
            return new LifecycleStatus(this);
        }
    }
}

