/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.model.internal.deterministic;

import com.swirlds.base.time.Time;
import com.swirlds.component.framework.model.TraceableWiringModel;
import com.swirlds.component.framework.model.internal.standard.AbstractHeartbeatScheduler;
import com.swirlds.component.framework.model.internal.standard.HeartbeatTask;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hiero.base.CompareTo;

public class DeterministicHeartbeatScheduler
extends AbstractHeartbeatScheduler {
    private final Map<Duration, List<HeartbeatTask>> heartbeatsByPeriod = new HashMap<Duration, List<HeartbeatTask>>();
    private final Map<Duration, Instant> previousHeartbeats = new HashMap<Duration, Instant>();

    public DeterministicHeartbeatScheduler(@NonNull TraceableWiringModel model, @NonNull Time time) {
        super(model, time);
    }

    public void tick() {
        if (!this.started) {
            throw new IllegalStateException("Cannot tick the heartbeat before it has started");
        }
        Instant currentTime = this.time.now();
        for (Map.Entry<Duration, List<HeartbeatTask>> entry : this.heartbeatsByPeriod.entrySet()) {
            Duration period = entry.getKey();
            List<HeartbeatTask> tasksForPeriod = entry.getValue();
            Instant previousHeartbeat = this.previousHeartbeats.get(period);
            Duration timeSinceLastHeartbeat = Duration.between(previousHeartbeat, currentTime);
            if (!CompareTo.isGreaterThanOrEqualTo((Comparable)timeSinceLastHeartbeat, (Object)period)) continue;
            for (HeartbeatTask task : tasksForPeriod) {
                task.run();
            }
            this.previousHeartbeats.put(period, currentTime);
        }
    }

    @Override
    public void start() {
        if (this.started) {
            throw new IllegalStateException("Cannot start the heartbeat more than once");
        }
        Instant currentTime = this.time.now();
        for (HeartbeatTask task : this.tasks) {
            List tasksForPeriod = this.heartbeatsByPeriod.computeIfAbsent(task.getPeriod(), k -> new ArrayList());
            tasksForPeriod.add(task);
            this.previousHeartbeats.put(task.getPeriod(), currentTime);
        }
        this.started = true;
    }

    @Override
    public void stop() {
        if (!this.started) {
            throw new IllegalStateException("Cannot stop the heartbeat before it has started");
        }
    }
}

