/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.lifecycle;

import com.hedera.hapi.node.base.SemanticVersion;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.utility.CommonUtils;
import org.hiero.base.utility.NonCryptographicHashing;

public final class StateMetadata<K, V> {
    private static final String ON_DISK_KEY_CLASS_ID_SUFFIX = "OnDiskKey";
    private static final String ON_DISK_KEY_SERIALIZER_CLASS_ID_SUFFIX = "OnDiskKeySerializer";
    private static final String ON_DISK_VALUE_CLASS_ID_SUFFIX = "OnDiskValue";
    private static final String ON_DISK_VALUE_SERIALIZER_CLASS_ID_SUFFIX = "OnDiskValueSerializer";
    private static final String IN_MEMORY_VALUE_CLASS_ID_SUFFIX = "InMemoryValue";
    private static final String SINGLETON_CLASS_ID_SUFFIX = "SingletonLeaf";
    private static final String QUEUE_NODE_CLASS_ID_SUFFIX = "QueueNode";
    private static final Logger logger = LogManager.getLogger(StateMetadata.class);
    private final String serviceName;
    private final Schema schema;
    private final StateDefinition<K, V> stateDefinition;
    private final long onDiskKeyClassId;
    private final long onDiskKeySerializerClassId;
    private final long onDiskValueClassId;
    private final long onDiskValueSerializerClassId;
    private final long inMemoryValueClassId;
    private final long singletonClassId;
    private final long queueNodeClassId;

    public StateMetadata(@NonNull String serviceName, @NonNull Schema schema, @NonNull StateDefinition<K, V> stateDefinition) {
        this.serviceName = StateMetadata.validateServiceName(serviceName);
        this.schema = schema;
        this.stateDefinition = stateDefinition;
        String stateKey = stateDefinition.stateKey();
        SemanticVersion version = schema.getVersion();
        this.onDiskKeyClassId = StateMetadata.computeClassId(serviceName, stateKey, version, ON_DISK_KEY_CLASS_ID_SUFFIX);
        this.onDiskKeySerializerClassId = StateMetadata.computeClassId(serviceName, stateKey, version, ON_DISK_KEY_SERIALIZER_CLASS_ID_SUFFIX);
        this.onDiskValueClassId = StateMetadata.computeClassId(serviceName, stateKey, version, ON_DISK_VALUE_CLASS_ID_SUFFIX);
        this.onDiskValueSerializerClassId = StateMetadata.computeClassId(serviceName, stateKey, version, ON_DISK_VALUE_SERIALIZER_CLASS_ID_SUFFIX);
        this.inMemoryValueClassId = StateMetadata.computeClassId(serviceName, stateKey, version, IN_MEMORY_VALUE_CLASS_ID_SUFFIX);
        this.singletonClassId = StateMetadata.computeClassId(serviceName, stateKey, version, SINGLETON_CLASS_ID_SUFFIX);
        this.queueNodeClassId = StateMetadata.computeClassId(serviceName, stateKey, version, QUEUE_NODE_CLASS_ID_SUFFIX);
    }

    public static long computeClassId(@NonNull String serviceName, @NonNull String stateKey, @NonNull SemanticVersion version, @NonNull String extra) {
        String ver = "v" + version.major() + "." + version.minor() + "." + version.patch();
        return StateMetadata.hashString(serviceName + ":" + stateKey + ":" + ver + ":" + extra);
    }

    public static long hashString(@NonNull String s) {
        byte[] data = CommonUtils.getNormalisedStringBytes((String)s);
        return StateMetadata.hashBytes(data);
    }

    private static long hashBytes(@NonNull byte[] bytes) {
        int numBlocks = bytes.length / 8;
        long hash = 0L;
        for (int i = 0; i < numBlocks * 8; i += 8) {
            hash ^= (long)bytes[i] << 56;
            hash ^= (long)bytes[i + 1] << 48;
            hash ^= (long)bytes[i + 2] << 40;
            hash ^= (long)bytes[i + 3] << 32;
            hash ^= (long)(bytes[i + 4] << 24);
            hash ^= (long)(bytes[i + 5] << 16);
            hash ^= (long)(bytes[i + 6] << 8);
            hash ^= (long)bytes[i + 7];
            hash = NonCryptographicHashing.hash64((long)hash);
        }
        int numRemainingBytes = bytes.length - numBlocks * 8;
        if (numRemainingBytes > 0) {
            int shift = numRemainingBytes * 8;
            int i = numBlocks * 8;
            while (i < bytes.length) {
                hash ^= (long)bytes[i] << shift;
                ++i;
                shift -= 8;
            }
            hash = NonCryptographicHashing.hash64((long)hash);
        }
        return hash;
    }

    @NonNull
    public static String validateServiceName(@NonNull String serviceName) {
        if (Objects.requireNonNull(serviceName).isEmpty()) {
            throw new IllegalArgumentException("The service name must have characters");
        }
        return StateMetadata.validateIdentifier(serviceName);
    }

    @NonNull
    public static String validateStateKey(@NonNull String stateKey) {
        if (Objects.requireNonNull(stateKey).isEmpty()) {
            throw new IllegalArgumentException("The state key must have characters");
        }
        return StateMetadata.validateIdentifier(stateKey);
    }

    @NonNull
    public static String validateIdentifier(@NonNull String stateKey) {
        if (Objects.requireNonNull(stateKey).isEmpty()) {
            throw new IllegalArgumentException("The identifier must have characters");
        }
        for (int i = 0; i < stateKey.length(); ++i) {
            char c = stateKey.charAt(i);
            if (StateMetadata.isAsciiUnderscoreOrDash(c) || StateMetadata.isAsciiLetter(c) || StateMetadata.isAsciiNumber(c)) continue;
            throw new IllegalArgumentException("Illegal character '" + c + "' at position " + i);
        }
        return stateKey;
    }

    public static String computeLabel(@NonNull String serviceName, @NonNull String stateKey) {
        return Objects.requireNonNull(serviceName) + "." + Objects.requireNonNull(stateKey);
    }

    private static boolean isAsciiUnderscoreOrDash(char ch) {
        return ch == '-' || ch == '_';
    }

    private static boolean isAsciiLetter(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    private static boolean isAsciiNumber(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public String serviceName() {
        return this.serviceName;
    }

    public Schema schema() {
        return this.schema;
    }

    @NonNull
    public StateDefinition<K, V> stateDefinition() {
        return this.stateDefinition;
    }

    public long onDiskKeyClassId() {
        return this.onDiskKeyClassId;
    }

    public long onDiskKeySerializerClassId() {
        return this.onDiskKeySerializerClassId;
    }

    public long onDiskValueClassId() {
        return this.onDiskValueClassId;
    }

    public long onDiskValueSerializerClassId() {
        return this.onDiskValueSerializerClassId;
    }

    public long inMemoryValueClassId() {
        return this.inMemoryValueClassId;
    }

    public long singletonClassId() {
        return this.singletonClassId;
    }

    public long queueNodeClassId() {
        return this.queueNodeClassId;
    }
}

