/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui.components;

import com.swirlds.common.metrics.statistics.StatsBuffered;
import com.swirlds.common.metrics.statistics.internal.StatsBuffer;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.gui.components.ChartLabelModel;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Objects;
import javax.swing.JPanel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Chart
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(Chart.class);
    private final Color DARK_GRAY = new Color(0.8f, 0.8f, 0.8f);
    private final Color LIGHT_GRAY = new Color(0.9f, 0.9f, 0.9f);
    private final ChartLabelModel model;
    private final String metricName;
    private final transient StatsBuffered statsBuffered;
    private final boolean allHistory;
    private long numSteps;
    int stringHeight;
    int stringHeightNoDesc;
    int minXs;
    int maxXs;
    int minYs;
    int maxYs;
    double minXb;
    double maxXb;
    double minYb;
    double maxYb;
    double xDivisor = 1.0;
    String xUnits = "seconds";

    public Chart(@NonNull ChartLabelModel model, int width, int height, boolean allHistory, StatsBuffered statsBuffered, String metricName) {
        this.model = Objects.requireNonNull(model, "model must not be null");
        this.setPreferredSize(new Dimension(width, height));
        this.allHistory = allHistory;
        this.metricName = metricName;
        this.statsBuffered = statsBuffered;
        this.setBackground(Color.WHITE);
    }

    private int scaleX(double x) {
        if (this.minXb == this.maxXb) {
            return (this.minXs + this.maxXs) / 2;
        }
        return (int)(Math.min(1.0, Math.max(0.0, (x - this.minXb) / (this.maxXb - this.minXb))) * (double)(this.maxXs - this.minXs) + (double)this.minXs);
    }

    private int scaleY(double y) {
        if (this.minYb == this.maxYb) {
            return (this.minYs + this.maxYs) / 2;
        }
        return (int)((double)this.maxYs - Math.min(1.0, Math.max(0.0, (y - this.minYb) / (this.maxYb - this.minYb))) * (double)(this.maxYs - this.minYs));
    }

    private boolean good(double step, double min, double max) {
        if (step <= 0.0 || max < min) {
            return false;
        }
        this.numSteps = 1L + Math.round(Math.ceil(max / step) - Math.floor(min / step));
        return 4L <= this.numSteps && this.numSteps <= 7L;
    }

    private void findYLabel() {
        if (this.maxYb == this.minYb) {
            String s = String.format("%,.0f", this.minYb);
            this.model.setYLabels(new String[]{s});
            this.model.setYLabelValues(new double[]{this.minYb});
            return;
        }
        double step10 = Math.pow(10.0, Math.floor(Math.log10(this.maxYb - this.minYb)) - 1.0);
        double step = 1.0;
        for (int i = 0; !(i >= 4 || this.good(step = step10, this.minYb, this.maxYb) || this.good(step = step10 * 2.0, this.minYb, this.maxYb) || this.good(step = step10 * 5.0, this.minYb, this.maxYb)); ++i) {
            step10 *= 10.0;
        }
        long decimals = Math.round(Math.max(0.0, -Math.floor(Math.log10(step))));
        double epsilon = Math.pow(10.0, -1L - decimals);
        double localMaxYb = Math.ceil(this.maxYb / step) * step + epsilon;
        String[] yLabel = new String[(int)this.numSteps - 2];
        double[] yLabelVal = new double[(int)this.numSteps - 2];
        int i = 0;
        while ((long)i < this.numSteps - 2L) {
            yLabelVal[i] = localMaxYb - (double)(i + 1) * step + epsilon;
            yLabel[i] = String.format("%,." + decimals + "f", yLabelVal[i]);
            ++i;
        }
        this.model.setYLabels(yLabel);
        this.model.setYLabelValues(yLabelVal);
    }

    private void findXLabel() {
        if (this.maxXb <= this.minXb) {
            String s = String.format("%,.0f", this.minXb);
            this.model.setXLabels(new String[]{s});
            this.model.setXLabelValues(new double[]{this.minXb});
            return;
        }
        double step10 = Math.pow(10.0, Math.floor(Math.log10(this.maxXb - this.minXb)) - 1.0);
        double step = 1.0;
        for (int i = 0; !(i >= 4 || this.good(step = step10, this.minXb, this.maxXb) || this.good(step = step10 * 2.0, this.minXb, this.maxXb) || this.good(step = step10 * 5.0, this.minXb, this.maxXb)); ++i) {
            step10 *= 10.0;
        }
        if (!this.good(step, this.minXb, this.maxXb)) {
            this.numSteps = 4L;
            step = 1.0;
        }
        long decimals = Math.round(Math.max(0.0, -Math.floor(Math.log10(step))));
        double epsilon = Math.pow(10.0, -1L - decimals);
        double localMaxXb = Math.ceil(this.maxXb / step) * step + epsilon;
        String[] xLabel = new String[(int)this.numSteps - 2];
        double[] xLabelVal = new double[(int)this.numSteps - 2];
        int i = 0;
        while ((long)i < this.numSteps - 2L) {
            xLabelVal[i] = localMaxXb - (double)(i + 1) * step + epsilon;
            xLabel[i] = String.format("%,." + decimals + "f", xLabelVal[i]);
            ++i;
        }
        this.model.setXLabels(xLabel);
        this.model.setXLabelValues(xLabelVal);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        try {
            int stringWidth;
            int i;
            StatsBuffer buffer = this.allHistory ? this.statsBuffered.getAllHistory() : this.statsBuffered.getRecentHistory();
            this.minXs = 120;
            this.maxXs = this.getWidth() - 55;
            this.minYs = 40;
            this.maxYs = this.getHeight() - 50;
            this.minXb = buffer.xMin();
            this.maxXb = buffer.xMax();
            this.minYb = buffer.yMin();
            this.maxYb = buffer.yMax();
            if (this.maxXb - this.minXb > 3.1536E7) {
                this.xDivisor = 3.1536E7;
                this.xUnits = "years";
            } else if (this.maxXb - this.minXb > 86400.0) {
                this.xDivisor = 86400.0;
                this.xUnits = "days";
            } else if (this.maxXb - this.minXb > 3600.0) {
                this.xDivisor = 3600.0;
                this.xUnits = "hours";
            } else if (this.maxXb - this.minXb > 66.0) {
                this.xDivisor = 60.0;
                this.xUnits = "minutes";
            } else {
                this.xDivisor = 1.0;
                this.xUnits = "seconds";
            }
            g.setColor(Color.BLACK);
            this.stringHeight = g.getFontMetrics().getHeight();
            this.stringHeightNoDesc = g.getFontMetrics().getHeight() - g.getFontMetrics().getDescent();
            String title = this.metricName + " vs. time for " + (this.allHistory ? "all" : "recent") + " history";
            if (buffer.numBins() == 0) {
                String s = "Skipping the first 60 seconds ...";
                int w = g.getFontMetrics().stringWidth("Skipping the first 60 seconds ...");
                g.drawString("Skipping the first 60 seconds ...", (this.minXs + this.maxXs - w) / 2, (this.minYs + this.maxYs) / 2);
                g.drawLine(this.minXs, this.maxYs, this.maxXs, this.maxYs);
                g.drawLine(this.minXs, this.minYs, this.minXs, this.maxYs);
            }
            for (int i2 = 0; i2 < buffer.numBins(); ++i2) {
                g.setColor(this.LIGHT_GRAY);
                int x0 = this.scaleX(i2 == 0 ? buffer.xMin(i2) : buffer.xMax(i2 - 1));
                int y0 = this.scaleY(buffer.yMax(i2));
                int x1 = this.scaleX(buffer.xMax(i2));
                int y1 = this.scaleY(buffer.yMin(i2));
                g.fillRect(x0, y0, x1 - x0, y1 - y0);
                g.setColor(this.DARK_GRAY);
                x0 = this.scaleX(i2 == 0 ? buffer.xMin(i2) : buffer.xMax(i2 - 1));
                y0 = this.scaleY(buffer.yAvg(i2) + buffer.yStd(i2));
                x1 = this.scaleX(buffer.xMax(i2));
                y1 = this.scaleY(buffer.yAvg(i2) - buffer.yStd(i2));
                g.fillRect(x0, y0, x1 - x0, y1 - y0);
                g.setColor(Color.BLUE);
                if (i2 <= 0) continue;
                x0 = this.scaleX(buffer.xAvg(i2 - 1));
                y0 = this.scaleY(buffer.yAvg(i2 - 1));
                x1 = this.scaleX(buffer.xAvg(i2));
                y1 = this.scaleY(buffer.yAvg(i2));
                g.drawLine(x0, y0, x1, y1);
            }
            g.setColor(Color.BLACK);
            int w = g.getFontMetrics().stringWidth(title);
            g.drawString(title, this.minXs + (this.maxXs - this.minXs - w) / 2, this.stringHeight);
            String s = "Time in the past (in " + this.xUnits + ")";
            w = g.getFontMetrics().stringWidth(s);
            g.drawString(s, this.minXs + (this.maxXs - this.minXs - w) / 2, this.getHeight() - this.stringHeight);
            if (buffer.numBins() == 0) {
                return;
            }
            double tt = this.minXb;
            this.minXb = (this.minXb - tt) / this.xDivisor;
            this.maxXb = (this.maxXb - tt) / this.xDivisor;
            double t2 = (this.maxXb - this.minXb) / 50.0;
            this.minXb -= t2;
            this.findXLabel();
            this.minXb += t2;
            this.minXb = this.minXb * this.xDivisor + tt;
            this.maxXb = this.maxXb * this.xDivisor + tt;
            double[] xLabelVal = new double[this.model.getXLabelValues().length];
            for (i = 0; i < this.model.getXLabelValues().length; ++i) {
                xLabelVal[i] = this.model.getXLabelValues()[i] * this.xDivisor + tt;
            }
            this.model.setXLabelValues(xLabelVal);
            for (i = 0; i < this.model.getXLabels().length; ++i) {
                int x = this.maxXs - (this.scaleX(this.model.getXLabelValues()[i]) - this.minXs);
                stringWidth = g.getFontMetrics().stringWidth(this.model.getXLabels()[i]);
                g.drawLine(x, this.maxYs + 4, x, this.maxYs - 4);
                g.drawString(this.model.getXLabels()[i], x - stringWidth / 2 + 1, this.maxYs + this.stringHeight + 5);
            }
            this.findYLabel();
            for (i = 0; i < this.model.getYLabels().length; ++i) {
                int y = this.scaleY(this.model.getYLabelValues()[i]);
                stringWidth = g.getFontMetrics().stringWidth(this.model.getYLabels()[i]);
                g.drawLine(this.minXs - 4, y, this.minXs + 4, y);
                g.drawString(this.model.getYLabels()[i], this.minXs - stringWidth - 10, y + this.stringHeightNoDesc / 2 - 1);
            }
            g.drawLine(this.minXs, this.maxYs, this.maxXs, this.maxYs);
            g.drawLine(this.minXs, this.minYs, this.minXs, this.maxYs);
        }
        catch (Exception e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "error while painting: {}", (Throwable)e);
        }
    }
}

