/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.debugging;

import java.util.LinkedList;
import java.util.List;
import org.mockito.internal.debugging.FindingsListener;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.util.StringUtil;
import org.mockito.invocation.Invocation;

public class LoggingListener
implements FindingsListener {
    private final boolean warnAboutUnstubbed;
    private final List<String> argMismatchStubs = new LinkedList<String>();
    private final List<String> unusedStubs = new LinkedList<String>();
    private final List<String> unstubbedCalls = new LinkedList<String>();

    public LoggingListener(boolean warnAboutUnstubbed) {
        this.warnAboutUnstubbed = warnAboutUnstubbed;
    }

    @Override
    public void foundStubCalledWithDifferentArgs(Invocation unused, InvocationMatcher unstubbed) {
        String index = Integer.toString(LoggingListener.indexOfNextPair(this.argMismatchStubs.size()));
        String padding = index.replaceAll("\\d", " ");
        this.argMismatchStubs.add(index + ". Stubbed " + String.valueOf(unused.getLocation()));
        this.argMismatchStubs.add(padding + "  Invoked " + String.valueOf(unstubbed.getInvocation().getLocation()));
    }

    static int indexOfNextPair(int collectionSize) {
        return collectionSize / 2 + 1;
    }

    @Override
    public void foundUnusedStub(Invocation unused) {
        this.unusedStubs.add(this.unusedStubs.size() + 1 + ". " + String.valueOf(unused.getLocation()));
    }

    @Override
    public void foundUnstubbed(InvocationMatcher unstubbed) {
        if (this.warnAboutUnstubbed) {
            this.unstubbedCalls.add(this.unstubbedCalls.size() + 1 + ". " + String.valueOf(unstubbed.getInvocation().getLocation()));
        }
    }

    public String getStubbingInfo() {
        if (this.argMismatchStubs.isEmpty() && this.unusedStubs.isEmpty() && this.unstubbedCalls.isEmpty()) {
            return "";
        }
        LinkedList<String> lines = new LinkedList<String>();
        lines.add("[Mockito] Additional stubbing information (see javadoc for StubbingInfo class):");
        if (!this.argMismatchStubs.isEmpty()) {
            lines.add("[Mockito]");
            lines.add("[Mockito] Argument mismatch between stubbing and actual invocation (is stubbing correct in the test?):");
            lines.add("[Mockito]");
            this.addOrderedList(lines, this.argMismatchStubs);
        }
        if (!this.unusedStubs.isEmpty()) {
            lines.add("[Mockito]");
            lines.add("[Mockito] Unused stubbing (perhaps can be removed from the test?):");
            lines.add("[Mockito]");
            this.addOrderedList(lines, this.unusedStubs);
        }
        if (!this.unstubbedCalls.isEmpty()) {
            lines.add("[Mockito]");
            lines.add("[Mockito] Un-stubbed method invocations (perhaps missing stubbing in the test?):");
            lines.add("[Mockito]");
            this.addOrderedList(lines, this.unstubbedCalls);
        }
        return StringUtil.join("", lines);
    }

    private void addOrderedList(List<String> target, List<String> additions) {
        for (String a : additions) {
            target.add("[Mockito] " + a);
        }
    }
}

