/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.blockstream;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.blockstream.codec.BlockStreamInfoJsonCodec;
import com.hedera.hapi.node.state.blockstream.codec.BlockStreamInfoProtoCodec;
import com.hedera.hapi.node.state.blockstream.schema.BlockStreamInfoSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class BlockStreamInfo {
    public static final Codec<BlockStreamInfo> PROTOBUF = new BlockStreamInfoProtoCodec();
    public static final JsonCodec<BlockStreamInfo> JSON = new BlockStreamInfoJsonCodec();
    public static final BlockStreamInfo DEFAULT = BlockStreamInfo.newBuilder().build();
    private final long blockNumber;
    @Nullable
    private final Timestamp blockTime;
    @NonNull
    private final Bytes trailingOutputHashes;
    @NonNull
    private final Bytes trailingBlockHashes;
    @NonNull
    private final Bytes inputTreeRootHash;
    @NonNull
    private final Bytes startOfBlockStateHash;
    private final int numPrecedingStateChangesItems;
    @NonNull
    private final List<Bytes> rightmostPrecedingStateChangesTreeHashes;
    @Nullable
    private final Timestamp blockEndTime;
    private final boolean postUpgradeWorkDone;
    @Nullable
    private final SemanticVersion creationSoftwareVersion;
    @Nullable
    private final Timestamp lastIntervalProcessTime;
    @Nullable
    private final Timestamp lastHandleTime;
    @NonNull
    private final Bytes consensusHeaderTreeRootHash;
    @NonNull
    private final Bytes traceDataTreeRootHash;
    @NonNull
    private final Bytes outputTreeRootHash;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public BlockStreamInfo(long blockNumber, Timestamp blockTime, Bytes trailingOutputHashes, Bytes trailingBlockHashes, Bytes inputTreeRootHash, Bytes startOfBlockStateHash, int numPrecedingStateChangesItems, List<Bytes> rightmostPrecedingStateChangesTreeHashes, Timestamp blockEndTime, boolean postUpgradeWorkDone, SemanticVersion creationSoftwareVersion, Timestamp lastIntervalProcessTime, Timestamp lastHandleTime, Bytes consensusHeaderTreeRootHash, Bytes traceDataTreeRootHash, Bytes outputTreeRootHash) {
        this.$unknownFields = null;
        this.blockNumber = blockNumber;
        this.blockTime = blockTime;
        this.trailingOutputHashes = trailingOutputHashes != null ? trailingOutputHashes : Bytes.EMPTY;
        this.trailingBlockHashes = trailingBlockHashes != null ? trailingBlockHashes : Bytes.EMPTY;
        this.inputTreeRootHash = inputTreeRootHash != null ? inputTreeRootHash : Bytes.EMPTY;
        this.startOfBlockStateHash = startOfBlockStateHash != null ? startOfBlockStateHash : Bytes.EMPTY;
        this.numPrecedingStateChangesItems = numPrecedingStateChangesItems;
        this.rightmostPrecedingStateChangesTreeHashes = rightmostPrecedingStateChangesTreeHashes != null ? rightmostPrecedingStateChangesTreeHashes : Collections.emptyList();
        this.blockEndTime = blockEndTime;
        this.postUpgradeWorkDone = postUpgradeWorkDone;
        this.creationSoftwareVersion = creationSoftwareVersion;
        this.lastIntervalProcessTime = lastIntervalProcessTime;
        this.lastHandleTime = lastHandleTime;
        this.consensusHeaderTreeRootHash = consensusHeaderTreeRootHash != null ? consensusHeaderTreeRootHash : Bytes.EMPTY;
        this.traceDataTreeRootHash = traceDataTreeRootHash != null ? traceDataTreeRootHash : Bytes.EMPTY;
        this.outputTreeRootHash = outputTreeRootHash != null ? outputTreeRootHash : Bytes.EMPTY;
    }

    public BlockStreamInfo(long blockNumber, Timestamp blockTime, Bytes trailingOutputHashes, Bytes trailingBlockHashes, Bytes inputTreeRootHash, Bytes startOfBlockStateHash, int numPrecedingStateChangesItems, List<Bytes> rightmostPrecedingStateChangesTreeHashes, Timestamp blockEndTime, boolean postUpgradeWorkDone, SemanticVersion creationSoftwareVersion, Timestamp lastIntervalProcessTime, Timestamp lastHandleTime, Bytes consensusHeaderTreeRootHash, Bytes traceDataTreeRootHash, Bytes outputTreeRootHash, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.blockNumber = blockNumber;
        this.blockTime = blockTime;
        this.trailingOutputHashes = trailingOutputHashes != null ? trailingOutputHashes : Bytes.EMPTY;
        this.trailingBlockHashes = trailingBlockHashes != null ? trailingBlockHashes : Bytes.EMPTY;
        this.inputTreeRootHash = inputTreeRootHash != null ? inputTreeRootHash : Bytes.EMPTY;
        this.startOfBlockStateHash = startOfBlockStateHash != null ? startOfBlockStateHash : Bytes.EMPTY;
        this.numPrecedingStateChangesItems = numPrecedingStateChangesItems;
        this.rightmostPrecedingStateChangesTreeHashes = rightmostPrecedingStateChangesTreeHashes != null ? rightmostPrecedingStateChangesTreeHashes : Collections.emptyList();
        this.blockEndTime = blockEndTime;
        this.postUpgradeWorkDone = postUpgradeWorkDone;
        this.creationSoftwareVersion = creationSoftwareVersion;
        this.lastIntervalProcessTime = lastIntervalProcessTime;
        this.lastHandleTime = lastHandleTime;
        this.consensusHeaderTreeRootHash = consensusHeaderTreeRootHash != null ? consensusHeaderTreeRootHash : Bytes.EMPTY;
        this.traceDataTreeRootHash = traceDataTreeRootHash != null ? traceDataTreeRootHash : Bytes.EMPTY;
        this.outputTreeRootHash = outputTreeRootHash != null ? outputTreeRootHash : Bytes.EMPTY;
    }

    public long blockNumber() {
        return this.blockNumber;
    }

    public Timestamp blockTime() {
        return this.blockTime;
    }

    public Bytes trailingOutputHashes() {
        return this.trailingOutputHashes;
    }

    public Bytes trailingBlockHashes() {
        return this.trailingBlockHashes;
    }

    public Bytes inputTreeRootHash() {
        return this.inputTreeRootHash;
    }

    public Bytes startOfBlockStateHash() {
        return this.startOfBlockStateHash;
    }

    public int numPrecedingStateChangesItems() {
        return this.numPrecedingStateChangesItems;
    }

    public List<Bytes> rightmostPrecedingStateChangesTreeHashes() {
        return this.rightmostPrecedingStateChangesTreeHashes;
    }

    public Timestamp blockEndTime() {
        return this.blockEndTime;
    }

    public boolean postUpgradeWorkDone() {
        return this.postUpgradeWorkDone;
    }

    public SemanticVersion creationSoftwareVersion() {
        return this.creationSoftwareVersion;
    }

    public Timestamp lastIntervalProcessTime() {
        return this.lastIntervalProcessTime;
    }

    public Timestamp lastHandleTime() {
        return this.lastHandleTime;
    }

    public Bytes consensusHeaderTreeRootHash() {
        return this.consensusHeaderTreeRootHash;
    }

    public Bytes traceDataTreeRootHash() {
        return this.traceDataTreeRootHash;
    }

    public Bytes outputTreeRootHash() {
        return this.outputTreeRootHash;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)BlockStreamInfoSchema.BLOCK_NUMBER, (long)this.blockNumber, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockStreamInfoSchema.BLOCK_TIME, (Object)this.blockTime, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)BlockStreamInfoSchema.TRAILING_OUTPUT_HASHES, (RandomAccessData)this.trailingOutputHashes, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)BlockStreamInfoSchema.TRAILING_BLOCK_HASHES, (RandomAccessData)this.trailingBlockHashes, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)BlockStreamInfoSchema.INPUT_TREE_ROOT_HASH, (RandomAccessData)this.inputTreeRootHash, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)BlockStreamInfoSchema.START_OF_BLOCK_STATE_HASH, (RandomAccessData)this.startOfBlockStateHash, (boolean)true);
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)BlockStreamInfoSchema.NUM_PRECEDING_STATE_CHANGES_ITEMS, (int)this.numPrecedingStateChangesItems, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytesList((FieldDefinition)BlockStreamInfoSchema.RIGHTMOST_PRECEDING_STATE_CHANGES_TREE_HASHES, this.rightmostPrecedingStateChangesTreeHashes);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockStreamInfoSchema.BLOCK_END_TIME, (Object)this.blockEndTime, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)BlockStreamInfoSchema.POST_UPGRADE_WORK_DONE, (boolean)this.postUpgradeWorkDone, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockStreamInfoSchema.CREATION_SOFTWARE_VERSION, (Object)this.creationSoftwareVersion, SemanticVersion.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockStreamInfoSchema.LAST_INTERVAL_PROCESS_TIME, (Object)this.lastIntervalProcessTime, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockStreamInfoSchema.LAST_HANDLE_TIME, (Object)this.lastHandleTime, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)BlockStreamInfoSchema.CONSENSUS_HEADER_TREE_ROOT_HASH, (RandomAccessData)this.consensusHeaderTreeRootHash, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)BlockStreamInfoSchema.TRACE_DATA_TREE_ROOT_HASH, (RandomAccessData)this.traceDataTreeRootHash, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)BlockStreamInfoSchema.OUTPUT_TREE_ROOT_HASH, (RandomAccessData)this.outputTreeRootHash, (boolean)true);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            List<Bytes> list$rightmostPrecedingStateChangesTreeHashes;
            int result = 1;
            if (this.blockNumber != BlockStreamInfo.DEFAULT.blockNumber) {
                result = 31 * result + Long.hashCode(this.blockNumber);
            }
            if (this.blockTime != null && !this.blockTime.equals(BlockStreamInfo.DEFAULT.blockTime)) {
                result = 31 * result + this.blockTime.hashCode();
            }
            if (this.trailingOutputHashes != null && !this.trailingOutputHashes.equals((Object)BlockStreamInfo.DEFAULT.trailingOutputHashes)) {
                result = 31 * result + this.trailingOutputHashes.hashCode();
            }
            if (this.trailingBlockHashes != null && !this.trailingBlockHashes.equals((Object)BlockStreamInfo.DEFAULT.trailingBlockHashes)) {
                result = 31 * result + this.trailingBlockHashes.hashCode();
            }
            if (this.inputTreeRootHash != null && !this.inputTreeRootHash.equals((Object)BlockStreamInfo.DEFAULT.inputTreeRootHash)) {
                result = 31 * result + this.inputTreeRootHash.hashCode();
            }
            if (this.startOfBlockStateHash != null && !this.startOfBlockStateHash.equals((Object)BlockStreamInfo.DEFAULT.startOfBlockStateHash)) {
                result = 31 * result + this.startOfBlockStateHash.hashCode();
            }
            if (this.numPrecedingStateChangesItems != BlockStreamInfo.DEFAULT.numPrecedingStateChangesItems) {
                result = 31 * result + Integer.hashCode(this.numPrecedingStateChangesItems);
            }
            if ((list$rightmostPrecedingStateChangesTreeHashes = this.rightmostPrecedingStateChangesTreeHashes) != null) {
                for (Bytes o : list$rightmostPrecedingStateChangesTreeHashes) {
                    if (o != null) {
                        result = 31 * result + o.hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.blockEndTime != null && !this.blockEndTime.equals(BlockStreamInfo.DEFAULT.blockEndTime)) {
                result = 31 * result + this.blockEndTime.hashCode();
            }
            if (this.postUpgradeWorkDone != BlockStreamInfo.DEFAULT.postUpgradeWorkDone) {
                result = 31 * result + Boolean.hashCode(this.postUpgradeWorkDone);
            }
            if (this.creationSoftwareVersion != null && !this.creationSoftwareVersion.equals(BlockStreamInfo.DEFAULT.creationSoftwareVersion)) {
                result = 31 * result + this.creationSoftwareVersion.hashCode();
            }
            if (this.lastIntervalProcessTime != null && !this.lastIntervalProcessTime.equals(BlockStreamInfo.DEFAULT.lastIntervalProcessTime)) {
                result = 31 * result + this.lastIntervalProcessTime.hashCode();
            }
            if (this.lastHandleTime != null && !this.lastHandleTime.equals(BlockStreamInfo.DEFAULT.lastHandleTime)) {
                result = 31 * result + this.lastHandleTime.hashCode();
            }
            if (this.consensusHeaderTreeRootHash != null && !this.consensusHeaderTreeRootHash.equals((Object)BlockStreamInfo.DEFAULT.consensusHeaderTreeRootHash)) {
                result = 31 * result + this.consensusHeaderTreeRootHash.hashCode();
            }
            if (this.traceDataTreeRootHash != null && !this.traceDataTreeRootHash.equals((Object)BlockStreamInfo.DEFAULT.traceDataTreeRootHash)) {
                result = 31 * result + this.traceDataTreeRootHash.hashCode();
            }
            if (this.outputTreeRootHash != null && !this.outputTreeRootHash.equals((Object)BlockStreamInfo.DEFAULT.outputTreeRootHash)) {
                result = 31 * result + this.outputTreeRootHash.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        BlockStreamInfo thatObj = (BlockStreamInfo)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.blockNumber != thatObj.blockNumber) {
            return false;
        }
        if (this.blockTime == null && thatObj.blockTime != null) {
            return false;
        }
        if (this.blockTime != null && !this.blockTime.equals(thatObj.blockTime)) {
            return false;
        }
        if (this.trailingOutputHashes == null && thatObj.trailingOutputHashes != null) {
            return false;
        }
        if (this.trailingOutputHashes != null && !this.trailingOutputHashes.equals((Object)thatObj.trailingOutputHashes)) {
            return false;
        }
        if (this.trailingBlockHashes == null && thatObj.trailingBlockHashes != null) {
            return false;
        }
        if (this.trailingBlockHashes != null && !this.trailingBlockHashes.equals((Object)thatObj.trailingBlockHashes)) {
            return false;
        }
        if (this.inputTreeRootHash == null && thatObj.inputTreeRootHash != null) {
            return false;
        }
        if (this.inputTreeRootHash != null && !this.inputTreeRootHash.equals((Object)thatObj.inputTreeRootHash)) {
            return false;
        }
        if (this.startOfBlockStateHash == null && thatObj.startOfBlockStateHash != null) {
            return false;
        }
        if (this.startOfBlockStateHash != null && !this.startOfBlockStateHash.equals((Object)thatObj.startOfBlockStateHash)) {
            return false;
        }
        if (this.numPrecedingStateChangesItems != thatObj.numPrecedingStateChangesItems) {
            return false;
        }
        if (this.rightmostPrecedingStateChangesTreeHashes == null && thatObj.rightmostPrecedingStateChangesTreeHashes != null) {
            return false;
        }
        if (this.rightmostPrecedingStateChangesTreeHashes != null && !this.rightmostPrecedingStateChangesTreeHashes.equals(thatObj.rightmostPrecedingStateChangesTreeHashes)) {
            return false;
        }
        if (this.blockEndTime == null && thatObj.blockEndTime != null) {
            return false;
        }
        if (this.blockEndTime != null && !this.blockEndTime.equals(thatObj.blockEndTime)) {
            return false;
        }
        if (this.postUpgradeWorkDone != thatObj.postUpgradeWorkDone) {
            return false;
        }
        if (this.creationSoftwareVersion == null && thatObj.creationSoftwareVersion != null) {
            return false;
        }
        if (this.creationSoftwareVersion != null && !this.creationSoftwareVersion.equals(thatObj.creationSoftwareVersion)) {
            return false;
        }
        if (this.lastIntervalProcessTime == null && thatObj.lastIntervalProcessTime != null) {
            return false;
        }
        if (this.lastIntervalProcessTime != null && !this.lastIntervalProcessTime.equals(thatObj.lastIntervalProcessTime)) {
            return false;
        }
        if (this.lastHandleTime == null && thatObj.lastHandleTime != null) {
            return false;
        }
        if (this.lastHandleTime != null && !this.lastHandleTime.equals(thatObj.lastHandleTime)) {
            return false;
        }
        if (this.consensusHeaderTreeRootHash == null && thatObj.consensusHeaderTreeRootHash != null) {
            return false;
        }
        if (this.consensusHeaderTreeRootHash != null && !this.consensusHeaderTreeRootHash.equals((Object)thatObj.consensusHeaderTreeRootHash)) {
            return false;
        }
        if (this.traceDataTreeRootHash == null && thatObj.traceDataTreeRootHash != null) {
            return false;
        }
        if (this.traceDataTreeRootHash != null && !this.traceDataTreeRootHash.equals((Object)thatObj.traceDataTreeRootHash)) {
            return false;
        }
        if (this.outputTreeRootHash == null && thatObj.outputTreeRootHash != null) {
            return false;
        }
        if (this.outputTreeRootHash != null && !this.outputTreeRootHash.equals((Object)thatObj.outputTreeRootHash)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "BlockStreamInfo[blockNumber=" + this.blockNumber + ", blockTime=" + String.valueOf(this.blockTime) + ", trailingOutputHashes=" + String.valueOf(this.trailingOutputHashes) + ", trailingBlockHashes=" + String.valueOf(this.trailingBlockHashes) + ", inputTreeRootHash=" + String.valueOf(this.inputTreeRootHash) + ", startOfBlockStateHash=" + String.valueOf(this.startOfBlockStateHash) + ", numPrecedingStateChangesItems=" + this.numPrecedingStateChangesItems + ", rightmostPrecedingStateChangesTreeHashes=" + String.valueOf(this.rightmostPrecedingStateChangesTreeHashes) + ", blockEndTime=" + String.valueOf(this.blockEndTime) + ", postUpgradeWorkDone=" + this.postUpgradeWorkDone + ", creationSoftwareVersion=" + String.valueOf(this.creationSoftwareVersion) + ", lastIntervalProcessTime=" + String.valueOf(this.lastIntervalProcessTime) + ", lastHandleTime=" + String.valueOf(this.lastHandleTime) + ", consensusHeaderTreeRootHash=" + String.valueOf(this.consensusHeaderTreeRootHash) + ", traceDataTreeRootHash=" + String.valueOf(this.traceDataTreeRootHash) + ", outputTreeRootHash=" + String.valueOf(this.outputTreeRootHash) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasBlockTime() {
        return this.blockTime != null;
    }

    public Timestamp blockTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasBlockTime() ? this.blockTime : defaultValue;
    }

    @NonNull
    public Timestamp blockTimeOrThrow() {
        return Objects.requireNonNull(this.blockTime, "Field blockTime is null");
    }

    public void ifBlockTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasBlockTime()) {
            ifPresent.accept(this.blockTime);
        }
    }

    public boolean hasBlockEndTime() {
        return this.blockEndTime != null;
    }

    public Timestamp blockEndTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasBlockEndTime() ? this.blockEndTime : defaultValue;
    }

    @NonNull
    public Timestamp blockEndTimeOrThrow() {
        return Objects.requireNonNull(this.blockEndTime, "Field blockEndTime is null");
    }

    public void ifBlockEndTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasBlockEndTime()) {
            ifPresent.accept(this.blockEndTime);
        }
    }

    public boolean hasCreationSoftwareVersion() {
        return this.creationSoftwareVersion != null;
    }

    public SemanticVersion creationSoftwareVersionOrElse(@NonNull SemanticVersion defaultValue) {
        return this.hasCreationSoftwareVersion() ? this.creationSoftwareVersion : defaultValue;
    }

    @NonNull
    public SemanticVersion creationSoftwareVersionOrThrow() {
        return Objects.requireNonNull(this.creationSoftwareVersion, "Field creationSoftwareVersion is null");
    }

    public void ifCreationSoftwareVersion(@NonNull Consumer<SemanticVersion> ifPresent) {
        if (this.hasCreationSoftwareVersion()) {
            ifPresent.accept(this.creationSoftwareVersion);
        }
    }

    public boolean hasLastIntervalProcessTime() {
        return this.lastIntervalProcessTime != null;
    }

    public Timestamp lastIntervalProcessTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasLastIntervalProcessTime() ? this.lastIntervalProcessTime : defaultValue;
    }

    @NonNull
    public Timestamp lastIntervalProcessTimeOrThrow() {
        return Objects.requireNonNull(this.lastIntervalProcessTime, "Field lastIntervalProcessTime is null");
    }

    public void ifLastIntervalProcessTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasLastIntervalProcessTime()) {
            ifPresent.accept(this.lastIntervalProcessTime);
        }
    }

    public boolean hasLastHandleTime() {
        return this.lastHandleTime != null;
    }

    public Timestamp lastHandleTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasLastHandleTime() ? this.lastHandleTime : defaultValue;
    }

    @NonNull
    public Timestamp lastHandleTimeOrThrow() {
        return Objects.requireNonNull(this.lastHandleTime, "Field lastHandleTime is null");
    }

    public void ifLastHandleTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasLastHandleTime()) {
            ifPresent.accept(this.lastHandleTime);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.blockNumber, this.blockTime, this.trailingOutputHashes, this.trailingBlockHashes, this.inputTreeRootHash, this.startOfBlockStateHash, this.numPrecedingStateChangesItems, this.rightmostPrecedingStateChangesTreeHashes, this.blockEndTime, this.postUpgradeWorkDone, this.creationSoftwareVersion, this.lastIntervalProcessTime, this.lastHandleTime, this.consensusHeaderTreeRootHash, this.traceDataTreeRootHash, this.outputTreeRootHash, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private long blockNumber = 0L;
        @Nullable
        private Timestamp blockTime = null;
        @NonNull
        private Bytes trailingOutputHashes = Bytes.EMPTY;
        @NonNull
        private Bytes trailingBlockHashes = Bytes.EMPTY;
        @NonNull
        private Bytes inputTreeRootHash = Bytes.EMPTY;
        @NonNull
        private Bytes startOfBlockStateHash = Bytes.EMPTY;
        private int numPrecedingStateChangesItems = 0;
        @NonNull
        private List<Bytes> rightmostPrecedingStateChangesTreeHashes = Collections.emptyList();
        @Nullable
        private Timestamp blockEndTime = null;
        private boolean postUpgradeWorkDone = false;
        @Nullable
        private SemanticVersion creationSoftwareVersion = null;
        @Nullable
        private Timestamp lastIntervalProcessTime = null;
        @Nullable
        private Timestamp lastHandleTime = null;
        @NonNull
        private Bytes consensusHeaderTreeRootHash = Bytes.EMPTY;
        @NonNull
        private Bytes traceDataTreeRootHash = Bytes.EMPTY;
        @NonNull
        private Bytes outputTreeRootHash = Bytes.EMPTY;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(long blockNumber, Timestamp blockTime, Bytes trailingOutputHashes, Bytes trailingBlockHashes, Bytes inputTreeRootHash, Bytes startOfBlockStateHash, int numPrecedingStateChangesItems, List<Bytes> rightmostPrecedingStateChangesTreeHashes, Timestamp blockEndTime, boolean postUpgradeWorkDone, SemanticVersion creationSoftwareVersion, Timestamp lastIntervalProcessTime, Timestamp lastHandleTime, Bytes consensusHeaderTreeRootHash, Bytes traceDataTreeRootHash, Bytes outputTreeRootHash) {
            this.$unknownFields = null;
            this.blockNumber = blockNumber;
            this.blockTime = blockTime;
            this.trailingOutputHashes = trailingOutputHashes != null ? trailingOutputHashes : Bytes.EMPTY;
            this.trailingBlockHashes = trailingBlockHashes != null ? trailingBlockHashes : Bytes.EMPTY;
            this.inputTreeRootHash = inputTreeRootHash != null ? inputTreeRootHash : Bytes.EMPTY;
            this.startOfBlockStateHash = startOfBlockStateHash != null ? startOfBlockStateHash : Bytes.EMPTY;
            this.numPrecedingStateChangesItems = numPrecedingStateChangesItems;
            this.rightmostPrecedingStateChangesTreeHashes = rightmostPrecedingStateChangesTreeHashes != null ? rightmostPrecedingStateChangesTreeHashes : Collections.emptyList();
            this.blockEndTime = blockEndTime;
            this.postUpgradeWorkDone = postUpgradeWorkDone;
            this.creationSoftwareVersion = creationSoftwareVersion;
            this.lastIntervalProcessTime = lastIntervalProcessTime;
            this.lastHandleTime = lastHandleTime;
            this.consensusHeaderTreeRootHash = consensusHeaderTreeRootHash != null ? consensusHeaderTreeRootHash : Bytes.EMPTY;
            this.traceDataTreeRootHash = traceDataTreeRootHash != null ? traceDataTreeRootHash : Bytes.EMPTY;
            this.outputTreeRootHash = outputTreeRootHash != null ? outputTreeRootHash : Bytes.EMPTY;
        }

        public Builder(long blockNumber, Timestamp blockTime, Bytes trailingOutputHashes, Bytes trailingBlockHashes, Bytes inputTreeRootHash, Bytes startOfBlockStateHash, int numPrecedingStateChangesItems, List<Bytes> rightmostPrecedingStateChangesTreeHashes, Timestamp blockEndTime, boolean postUpgradeWorkDone, SemanticVersion creationSoftwareVersion, Timestamp lastIntervalProcessTime, Timestamp lastHandleTime, Bytes consensusHeaderTreeRootHash, Bytes traceDataTreeRootHash, Bytes outputTreeRootHash, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.blockNumber = blockNumber;
            this.blockTime = blockTime;
            this.trailingOutputHashes = trailingOutputHashes != null ? trailingOutputHashes : Bytes.EMPTY;
            this.trailingBlockHashes = trailingBlockHashes != null ? trailingBlockHashes : Bytes.EMPTY;
            this.inputTreeRootHash = inputTreeRootHash != null ? inputTreeRootHash : Bytes.EMPTY;
            this.startOfBlockStateHash = startOfBlockStateHash != null ? startOfBlockStateHash : Bytes.EMPTY;
            this.numPrecedingStateChangesItems = numPrecedingStateChangesItems;
            this.rightmostPrecedingStateChangesTreeHashes = rightmostPrecedingStateChangesTreeHashes != null ? rightmostPrecedingStateChangesTreeHashes : Collections.emptyList();
            this.blockEndTime = blockEndTime;
            this.postUpgradeWorkDone = postUpgradeWorkDone;
            this.creationSoftwareVersion = creationSoftwareVersion;
            this.lastIntervalProcessTime = lastIntervalProcessTime;
            this.lastHandleTime = lastHandleTime;
            this.consensusHeaderTreeRootHash = consensusHeaderTreeRootHash != null ? consensusHeaderTreeRootHash : Bytes.EMPTY;
            this.traceDataTreeRootHash = traceDataTreeRootHash != null ? traceDataTreeRootHash : Bytes.EMPTY;
            this.outputTreeRootHash = outputTreeRootHash != null ? outputTreeRootHash : Bytes.EMPTY;
        }

        public BlockStreamInfo build() {
            return new BlockStreamInfo(this.blockNumber, this.blockTime, this.trailingOutputHashes, this.trailingBlockHashes, this.inputTreeRootHash, this.startOfBlockStateHash, this.numPrecedingStateChangesItems, this.rightmostPrecedingStateChangesTreeHashes, this.blockEndTime, this.postUpgradeWorkDone, this.creationSoftwareVersion, this.lastIntervalProcessTime, this.lastHandleTime, this.consensusHeaderTreeRootHash, this.traceDataTreeRootHash, this.outputTreeRootHash);
        }

        public Builder blockNumber(long blockNumber) {
            this.blockNumber = blockNumber;
            return this;
        }

        public Builder blockTime(@Nullable Timestamp blockTime) {
            this.blockTime = blockTime;
            return this;
        }

        public Builder blockTime(Timestamp.Builder builder) {
            this.blockTime = builder.build();
            return this;
        }

        public Builder trailingOutputHashes(@NonNull Bytes trailingOutputHashes) {
            this.trailingOutputHashes = trailingOutputHashes != null ? trailingOutputHashes : Bytes.EMPTY;
            return this;
        }

        public Builder trailingBlockHashes(@NonNull Bytes trailingBlockHashes) {
            this.trailingBlockHashes = trailingBlockHashes != null ? trailingBlockHashes : Bytes.EMPTY;
            return this;
        }

        public Builder inputTreeRootHash(@NonNull Bytes inputTreeRootHash) {
            this.inputTreeRootHash = inputTreeRootHash != null ? inputTreeRootHash : Bytes.EMPTY;
            return this;
        }

        public Builder startOfBlockStateHash(@NonNull Bytes startOfBlockStateHash) {
            this.startOfBlockStateHash = startOfBlockStateHash != null ? startOfBlockStateHash : Bytes.EMPTY;
            return this;
        }

        public Builder numPrecedingStateChangesItems(int numPrecedingStateChangesItems) {
            this.numPrecedingStateChangesItems = numPrecedingStateChangesItems;
            return this;
        }

        public Builder rightmostPrecedingStateChangesTreeHashes(@NonNull List<Bytes> rightmostPrecedingStateChangesTreeHashes) {
            this.rightmostPrecedingStateChangesTreeHashes = rightmostPrecedingStateChangesTreeHashes != null ? rightmostPrecedingStateChangesTreeHashes : Collections.emptyList();
            return this;
        }

        public Builder rightmostPrecedingStateChangesTreeHashes(Bytes ... values) {
            this.rightmostPrecedingStateChangesTreeHashes = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder blockEndTime(@Nullable Timestamp blockEndTime) {
            this.blockEndTime = blockEndTime;
            return this;
        }

        public Builder blockEndTime(Timestamp.Builder builder) {
            this.blockEndTime = builder.build();
            return this;
        }

        public Builder postUpgradeWorkDone(boolean postUpgradeWorkDone) {
            this.postUpgradeWorkDone = postUpgradeWorkDone;
            return this;
        }

        public Builder creationSoftwareVersion(@Nullable SemanticVersion creationSoftwareVersion) {
            this.creationSoftwareVersion = creationSoftwareVersion;
            return this;
        }

        public Builder creationSoftwareVersion(SemanticVersion.Builder builder) {
            this.creationSoftwareVersion = builder.build();
            return this;
        }

        public Builder lastIntervalProcessTime(@Nullable Timestamp lastIntervalProcessTime) {
            this.lastIntervalProcessTime = lastIntervalProcessTime;
            return this;
        }

        public Builder lastIntervalProcessTime(Timestamp.Builder builder) {
            this.lastIntervalProcessTime = builder.build();
            return this;
        }

        public Builder lastHandleTime(@Nullable Timestamp lastHandleTime) {
            this.lastHandleTime = lastHandleTime;
            return this;
        }

        public Builder lastHandleTime(Timestamp.Builder builder) {
            this.lastHandleTime = builder.build();
            return this;
        }

        public Builder consensusHeaderTreeRootHash(@NonNull Bytes consensusHeaderTreeRootHash) {
            this.consensusHeaderTreeRootHash = consensusHeaderTreeRootHash != null ? consensusHeaderTreeRootHash : Bytes.EMPTY;
            return this;
        }

        public Builder traceDataTreeRootHash(@NonNull Bytes traceDataTreeRootHash) {
            this.traceDataTreeRootHash = traceDataTreeRootHash != null ? traceDataTreeRootHash : Bytes.EMPTY;
            return this;
        }

        public Builder outputTreeRootHash(@NonNull Bytes outputTreeRootHash) {
            this.outputTreeRootHash = outputTreeRootHash != null ? outputTreeRootHash : Bytes.EMPTY;
            return this;
        }
    }
}

