/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.disk;

import com.hedera.hapi.platform.state.QueueState;
import com.swirlds.state.merkle.StateUtils;
import com.swirlds.state.merkle.disk.OnDiskQueueHelper;
import com.swirlds.state.merkle.logging.StateLogger;
import com.swirlds.state.spi.ReadableQueueStateBase;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Iterator;
import java.util.Objects;

public class OnDiskReadableQueueState<E>
extends ReadableQueueStateBase<E> {
    @NonNull
    private final OnDiskQueueHelper<E> onDiskQueueHelper;

    public OnDiskReadableQueueState(@NonNull String serviceName, @NonNull String stateKey, @NonNull VirtualMap virtualMap) {
        super(serviceName, stateKey);
        this.onDiskQueueHelper = new OnDiskQueueHelper(serviceName, stateKey, virtualMap);
    }

    @Nullable
    protected E peekOnDataSource() {
        QueueState state = this.onDiskQueueHelper.getState();
        Objects.requireNonNull(state);
        E value = OnDiskQueueHelper.isEmpty(state) ? null : (E)this.onDiskQueueHelper.getFromStore(state.head());
        StateLogger.logQueuePeek(StateUtils.computeLabel(this.serviceName, this.stateKey), value);
        return value;
    }

    @NonNull
    protected Iterator<E> iterateOnDataSource() {
        return this.onDiskQueueHelper.iterateOnDataSource();
    }
}

