/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.INTERNAL, since="1.7")
public class ClassNamePatternFilterUtils {
    public static final String DEACTIVATE_ALL_PATTERN = "*";

    private ClassNamePatternFilterUtils() {
    }

    public static <T> Predicate<T> excludeMatchingClasses(String patterns) {
        return ClassNamePatternFilterUtils.excludeMatchingClasses(patterns, object -> object.getClass().getName());
    }

    public static Predicate<String> excludeMatchingClassNames(String patterns) {
        return ClassNamePatternFilterUtils.excludeMatchingClasses(patterns, Function.identity());
    }

    private static <T> Predicate<T> excludeMatchingClasses(String patterns, Function<T, String> classNameGetter) {
        return Optional.ofNullable(patterns).filter(StringUtils::isNotBlank).map(String::trim).map(trimmedPatterns -> ClassNamePatternFilterUtils.createPredicateFromPatterns(trimmedPatterns, classNameGetter)).orElse(object -> true);
    }

    private static <T> Predicate<T> createPredicateFromPatterns(String patterns, Function<T, String> classNameProvider) {
        if (DEACTIVATE_ALL_PATTERN.equals(patterns)) {
            return object -> false;
        }
        List<Pattern> patternList = ClassNamePatternFilterUtils.convertToRegularExpressions(patterns);
        return object -> patternList.stream().noneMatch(it -> it.matcher((CharSequence)classNameProvider.apply(object)).matches());
    }

    private static List<Pattern> convertToRegularExpressions(String patterns) {
        return Arrays.stream(patterns.split(",")).filter(StringUtils::isNotBlank).map(String::trim).map(ClassNamePatternFilterUtils::replaceRegExElements).map(Pattern::compile).collect(Collectors.toList());
    }

    private static String replaceRegExElements(String pattern) {
        return Matcher.quoteReplacement(pattern).replace(".", "[.$]").replace(DEACTIVATE_ALL_PATTERN, ".+");
    }
}

