/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.history.codec;

import com.hedera.hapi.node.state.history.History;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class HistoryJsonCodec
implements JsonCodec<History> {
    @NonNull
    public History parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            Bytes temp_address_book_hash = Bytes.EMPTY;
            Bytes temp_metadata = Bytes.EMPTY;
            block10: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "addressBookHash": {
                        temp_address_book_hash = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block10;
                    }
                    case "metadata": {
                        temp_metadata = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block10;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new History(temp_address_book_hash, temp_metadata);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull History data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.addressBookHash() != Bytes.EMPTY && data.addressBookHash() != null && data.addressBookHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"addressBookHash", (Bytes)data.addressBookHash()));
        }
        if (data.metadata() != Bytes.EMPTY && data.metadata() != null && data.metadata().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"metadata", (Bytes)data.metadata()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

