/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.factory.set.primitive.MutableBooleanSetFactory;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.impl.factory.primitive.BooleanSets;
import org.eclipse.collections.impl.set.mutable.primitive.BooleanHashSet;
import org.eclipse.collections.impl.utility.Iterate;

@ServiceProvider(value=MutableBooleanSetFactory.class)
public class MutableBooleanSetFactoryImpl
implements MutableBooleanSetFactory {
    public static final MutableBooleanSetFactory INSTANCE = new MutableBooleanSetFactoryImpl();

    public MutableBooleanSet empty() {
        return new BooleanHashSet();
    }

    public MutableBooleanSet of() {
        return this.empty();
    }

    public MutableBooleanSet with() {
        return this.empty();
    }

    public MutableBooleanSet of(boolean ... items) {
        return this.with(items);
    }

    public MutableBooleanSet with(boolean ... items) {
        if (items == null || items.length == 0) {
            return this.empty();
        }
        return BooleanHashSet.newSetWith(items);
    }

    public MutableBooleanSet ofAll(BooleanIterable items) {
        return this.withAll(items);
    }

    public MutableBooleanSet withAll(BooleanIterable items) {
        return BooleanHashSet.newSet(items);
    }

    public MutableBooleanSet ofAll(Iterable<Boolean> iterable) {
        return this.withAll(iterable);
    }

    public MutableBooleanSet withAll(Iterable<Boolean> iterable) {
        return Iterate.collectBoolean(iterable, Boolean::booleanValue, BooleanSets.mutable.empty());
    }
}

