/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.freeze;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.freeze.FreezeType;
import com.hedera.hapi.node.freeze.codec.FreezeTransactionBodyJsonCodec;
import com.hedera.hapi.node.freeze.codec.FreezeTransactionBodyProtoCodec;
import com.hedera.hapi.node.freeze.schema.FreezeTransactionBodySchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class FreezeTransactionBody {
    public static final Codec<FreezeTransactionBody> PROTOBUF = new FreezeTransactionBodyProtoCodec();
    public static final JsonCodec<FreezeTransactionBody> JSON = new FreezeTransactionBodyJsonCodec();
    public static final FreezeTransactionBody DEFAULT = FreezeTransactionBody.newBuilder().build();
    private final int startHour;
    private final int startMin;
    private final int endHour;
    private final int endMin;
    @Nullable
    private final FileID updateFile;
    @NonNull
    private final Bytes fileHash;
    @Nullable
    private final Timestamp startTime;
    private final FreezeType freezeType;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public FreezeTransactionBody(int startHour, int startMin, int endHour, int endMin, FileID updateFile, Bytes fileHash, Timestamp startTime, FreezeType freezeType) {
        this.$unknownFields = null;
        this.startHour = startHour;
        this.startMin = startMin;
        this.endHour = endHour;
        this.endMin = endMin;
        this.updateFile = updateFile;
        this.fileHash = fileHash != null ? fileHash : Bytes.EMPTY;
        this.startTime = startTime;
        this.freezeType = freezeType;
    }

    public FreezeTransactionBody(int startHour, int startMin, int endHour, int endMin, FileID updateFile, Bytes fileHash, Timestamp startTime, FreezeType freezeType, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.startHour = startHour;
        this.startMin = startMin;
        this.endHour = endHour;
        this.endMin = endMin;
        this.updateFile = updateFile;
        this.fileHash = fileHash != null ? fileHash : Bytes.EMPTY;
        this.startTime = startTime;
        this.freezeType = freezeType;
    }

    public int startHour() {
        return this.startHour;
    }

    public int startMin() {
        return this.startMin;
    }

    public int endHour() {
        return this.endHour;
    }

    public int endMin() {
        return this.endMin;
    }

    public FileID updateFile() {
        return this.updateFile;
    }

    public Bytes fileHash() {
        return this.fileHash;
    }

    public Timestamp startTime() {
        return this.startTime;
    }

    public FreezeType freezeType() {
        return this.freezeType;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)FreezeTransactionBodySchema.START_HOUR, (int)this.startHour, (boolean)true);
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)FreezeTransactionBodySchema.START_MIN, (int)this.startMin, (boolean)true);
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)FreezeTransactionBodySchema.END_HOUR, (int)this.endHour, (boolean)true);
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)FreezeTransactionBodySchema.END_MIN, (int)this.endMin, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FreezeTransactionBodySchema.UPDATE_FILE, (Object)this.updateFile, FileID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)FreezeTransactionBodySchema.FILE_HASH, (RandomAccessData)this.fileHash, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FreezeTransactionBodySchema.START_TIME, (Object)this.startTime, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfEnum((FieldDefinition)FreezeTransactionBodySchema.FREEZE_TYPE, (EnumWithProtoMetadata)this.freezeType);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.startHour != FreezeTransactionBody.DEFAULT.startHour) {
                result = 31 * result + Integer.hashCode(this.startHour);
            }
            if (this.startMin != FreezeTransactionBody.DEFAULT.startMin) {
                result = 31 * result + Integer.hashCode(this.startMin);
            }
            if (this.endHour != FreezeTransactionBody.DEFAULT.endHour) {
                result = 31 * result + Integer.hashCode(this.endHour);
            }
            if (this.endMin != FreezeTransactionBody.DEFAULT.endMin) {
                result = 31 * result + Integer.hashCode(this.endMin);
            }
            if (this.updateFile != null && !this.updateFile.equals(FreezeTransactionBody.DEFAULT.updateFile)) {
                result = 31 * result + this.updateFile.hashCode();
            }
            if (this.fileHash != null && !this.fileHash.equals((Object)FreezeTransactionBody.DEFAULT.fileHash)) {
                result = 31 * result + this.fileHash.hashCode();
            }
            if (this.startTime != null && !this.startTime.equals(FreezeTransactionBody.DEFAULT.startTime)) {
                result = 31 * result + this.startTime.hashCode();
            }
            if (this.freezeType != null && !this.freezeType.equals((Object)FreezeTransactionBody.DEFAULT.freezeType)) {
                result = 31 * result + Integer.hashCode(this.freezeType.protoOrdinal());
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        FreezeTransactionBody thatObj = (FreezeTransactionBody)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.startHour != thatObj.startHour) {
            return false;
        }
        if (this.startMin != thatObj.startMin) {
            return false;
        }
        if (this.endHour != thatObj.endHour) {
            return false;
        }
        if (this.endMin != thatObj.endMin) {
            return false;
        }
        if (this.updateFile == null && thatObj.updateFile != null) {
            return false;
        }
        if (this.updateFile != null && !this.updateFile.equals(thatObj.updateFile)) {
            return false;
        }
        if (this.fileHash == null && thatObj.fileHash != null) {
            return false;
        }
        if (this.fileHash != null && !this.fileHash.equals((Object)thatObj.fileHash)) {
            return false;
        }
        if (this.startTime == null && thatObj.startTime != null) {
            return false;
        }
        if (this.startTime != null && !this.startTime.equals(thatObj.startTime)) {
            return false;
        }
        if (this.freezeType == null && thatObj.freezeType != null) {
            return false;
        }
        if (this.freezeType != null && !this.freezeType.equals((Object)thatObj.freezeType)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "FreezeTransactionBody[startHour=" + this.startHour + ", startMin=" + this.startMin + ", endHour=" + this.endHour + ", endMin=" + this.endMin + ", updateFile=" + String.valueOf(this.updateFile) + ", fileHash=" + String.valueOf(this.fileHash) + ", startTime=" + String.valueOf(this.startTime) + ", freezeType=" + String.valueOf((Object)this.freezeType) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasUpdateFile() {
        return this.updateFile != null;
    }

    public FileID updateFileOrElse(@NonNull FileID defaultValue) {
        return this.hasUpdateFile() ? this.updateFile : defaultValue;
    }

    @NonNull
    public FileID updateFileOrThrow() {
        return Objects.requireNonNull(this.updateFile, "Field updateFile is null");
    }

    public void ifUpdateFile(@NonNull Consumer<FileID> ifPresent) {
        if (this.hasUpdateFile()) {
            ifPresent.accept(this.updateFile);
        }
    }

    public boolean hasStartTime() {
        return this.startTime != null;
    }

    public Timestamp startTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasStartTime() ? this.startTime : defaultValue;
    }

    @NonNull
    public Timestamp startTimeOrThrow() {
        return Objects.requireNonNull(this.startTime, "Field startTime is null");
    }

    public void ifStartTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasStartTime()) {
            ifPresent.accept(this.startTime);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.startHour, this.startMin, this.endHour, this.endMin, this.updateFile, this.fileHash, this.startTime, this.freezeType, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private int startHour = 0;
        private int startMin = 0;
        private int endHour = 0;
        private int endMin = 0;
        @Nullable
        private FileID updateFile = null;
        @NonNull
        private Bytes fileHash = Bytes.EMPTY;
        @Nullable
        private Timestamp startTime = null;
        private FreezeType freezeType = FreezeType.fromProtobufOrdinal(0);
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(int startHour, int startMin, int endHour, int endMin, FileID updateFile, Bytes fileHash, Timestamp startTime, FreezeType freezeType) {
            this.$unknownFields = null;
            this.startHour = startHour;
            this.startMin = startMin;
            this.endHour = endHour;
            this.endMin = endMin;
            this.updateFile = updateFile;
            this.fileHash = fileHash != null ? fileHash : Bytes.EMPTY;
            this.startTime = startTime;
            this.freezeType = freezeType;
        }

        public Builder(int startHour, int startMin, int endHour, int endMin, FileID updateFile, Bytes fileHash, Timestamp startTime, FreezeType freezeType, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.startHour = startHour;
            this.startMin = startMin;
            this.endHour = endHour;
            this.endMin = endMin;
            this.updateFile = updateFile;
            this.fileHash = fileHash != null ? fileHash : Bytes.EMPTY;
            this.startTime = startTime;
            this.freezeType = freezeType;
        }

        public FreezeTransactionBody build() {
            return new FreezeTransactionBody(this.startHour, this.startMin, this.endHour, this.endMin, this.updateFile, this.fileHash, this.startTime, this.freezeType);
        }

        public Builder startHour(int startHour) {
            this.startHour = startHour;
            return this;
        }

        public Builder startMin(int startMin) {
            this.startMin = startMin;
            return this;
        }

        public Builder endHour(int endHour) {
            this.endHour = endHour;
            return this;
        }

        public Builder endMin(int endMin) {
            this.endMin = endMin;
            return this;
        }

        public Builder updateFile(@Nullable FileID updateFile) {
            this.updateFile = updateFile;
            return this;
        }

        public Builder updateFile(FileID.Builder builder) {
            this.updateFile = builder.build();
            return this;
        }

        public Builder fileHash(@NonNull Bytes fileHash) {
            this.fileHash = fileHash != null ? fileHash : Bytes.EMPTY;
            return this;
        }

        public Builder startTime(@Nullable Timestamp startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder startTime(Timestamp.Builder builder) {
            this.startTime = builder.build();
            return this;
        }

        public Builder freezeType(FreezeType freezeType) {
            this.freezeType = freezeType;
            return this;
        }
    }
}

