/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.merkle;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.impl.PartialBinaryMerkleInternal;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.datasource.VirtualHashRecord;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import com.swirlds.virtualmap.internal.Path;
import com.swirlds.virtualmap.internal.merkle.VirtualLeafNode;
import com.swirlds.virtualmap.internal.merkle.VirtualNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import org.hiero.base.constructable.ConstructableIgnored;
import org.hiero.base.crypto.Hash;

@ConstructableIgnored
public final class VirtualInternalNode
extends PartialBinaryMerkleInternal
implements MerkleInternal,
VirtualNode {
    private static final int NUMBER_OF_CHILDREN = 2;
    public static final long CLASS_ID = -5826388714229745985L;
    public static final int SERIALIZATION_VERSION = 1;
    private final VirtualMap map;
    private final VirtualHashRecord virtualHashRecord;

    public VirtualInternalNode(@NonNull VirtualMap map, @NonNull VirtualHashRecord virtualHashRecord) {
        this.map = Objects.requireNonNull(map);
        this.virtualHashRecord = Objects.requireNonNull(virtualHashRecord);
        this.setHash(virtualHashRecord.hash());
    }

    public int getNumberOfChildren() {
        return 2;
    }

    public <T extends MerkleNode> T getChild(int i) {
        VirtualNode node;
        if (i == 0) {
            node = this.getLeft();
        } else if (i == 1) {
            node = this.getRight();
        } else {
            return null;
        }
        if (node == null) {
            return null;
        }
        long targetPath = node.getPath();
        List<Integer> routePath = Path.getRouteStepsFromRoot(targetPath);
        MerkleRoute nodeRoute = this.map.getRoute().extendRoute(routePath);
        node.setRoute(nodeRoute);
        return (T)node;
    }

    public void setChild(int index, MerkleNode merkleNode) {
        throw new UnsupportedOperationException();
    }

    public void setChild(int index, MerkleNode merkleNode, MerkleRoute merkleRoute, boolean mayBeImmutable) {
        throw new UnsupportedOperationException();
    }

    protected void updateChildRoutes(MerkleRoute route) {
    }

    public VirtualNode getLeft() {
        return this.getChild(Path.getLeftChildPath(this.virtualHashRecord.path()));
    }

    public VirtualNode getRight() {
        return this.getChild(Path.getRightChildPath(this.virtualHashRecord.path()));
    }

    private VirtualNode getChild(long childPath) {
        if (childPath < this.map.getMetadata().getFirstLeafPath()) {
            return this.getInternalNode(childPath);
        }
        return this.getLeafNode(childPath);
    }

    private VirtualInternalNode getInternalNode(long path) {
        return VirtualInternalNode.getInternalNode(this.map, path);
    }

    public static VirtualInternalNode getInternalNode(VirtualMap map, long path) {
        assert (path != -1L);
        if (path >= map.getMetadata().getFirstLeafPath()) {
            return null;
        }
        Hash hash = map.getRecords().findHash(path);
        VirtualHashRecord rec = new VirtualHashRecord(path, hash);
        return new VirtualInternalNode(map, rec);
    }

    private VirtualLeafNode getLeafNode(long path) {
        return VirtualInternalNode.getLeafNode(this.map, path);
    }

    public static VirtualLeafNode getLeafNode(VirtualMap map, long path) {
        assert (path != -1L);
        assert (path != 0L);
        if (path < map.getMetadata().getFirstLeafPath() || path > map.getMetadata().getLastLeafPath()) {
            return null;
        }
        Hash hash = map.getRecords().findHash(path);
        VirtualLeafBytes rec = map.getRecords().findLeafRecord(path);
        if (rec == null) {
            throw new IllegalStateException("Failed to find leaf node data: " + path);
        }
        return new VirtualLeafNode(rec, hash);
    }

    public VirtualInternalNode copy() {
        throw new UnsupportedOperationException("Don't use this. Need a map pointer.");
    }

    public long getClassId() {
        return -5826388714229745985L;
    }

    public int getVersion() {
        return 1;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.virtualHashRecord).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualInternalNode)) {
            return false;
        }
        VirtualInternalNode that = (VirtualInternalNode)o;
        return this.virtualHashRecord.equals(that.virtualHashRecord);
    }

    public int hashCode() {
        return Objects.hash(this.virtualHashRecord);
    }

    @Override
    public long getPath() {
        return this.virtualHashRecord.path();
    }
}

