/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.crypto.test.fixtures;

import com.goterl.lazysodium.LazySodiumJava;
import com.goterl.lazysodium.SodiumJava;
import com.goterl.lazysodium.interfaces.Sign;
import java.security.SignatureException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.base.crypto.test.fixtures.SigningProvider;
import org.hiero.base.utility.CommonUtils;

public class ED25519SigningProvider
implements SigningProvider {
    public static final int SIGNATURE_LENGTH = 64;
    public static final int PUBLIC_KEY_LENGTH = 32;
    public static final int PRIVATE_KEY_LENGTH = 64;
    private static final Logger logger = LogManager.getLogger(ED25519SigningProvider.class);
    private static final Marker LOGM_STARTUP = MarkerManager.getMarker((String)"STARTUP");
    private byte[] privateKey;
    private byte[] publicKey;
    private Sign.Native signer;
    private boolean algorithmAvailable = false;

    public ED25519SigningProvider() {
        this.tryAcquireSignature();
    }

    @Override
    public byte[] sign(byte[] data) throws SignatureException {
        byte[] sig = new byte[64];
        if (!this.signer.cryptoSignDetached(sig, data, (long)data.length, this.privateKey)) {
            throw new SignatureException();
        }
        return sig;
    }

    @Override
    public byte[] getPublicKeyBytes() {
        return this.publicKey;
    }

    @Override
    public int getSignatureLength() {
        return 64;
    }

    @Override
    public byte[] getPrivateKeyBytes() {
        return this.privateKey;
    }

    @Override
    public boolean isAlgorithmAvailable() {
        return this.algorithmAvailable;
    }

    private void tryAcquireSignature() {
        SodiumJava sodium = new SodiumJava();
        this.signer = new LazySodiumJava(sodium);
        this.publicKey = new byte[32];
        this.privateKey = new byte[64];
        this.algorithmAvailable = this.signer.cryptoSignKeypair(this.publicKey, this.privateKey);
        logger.trace(LOGM_STARTUP, "Public Key -> hex('{}')", new Supplier[]{() -> CommonUtils.hex((byte[])this.publicKey)});
        this.algorithmAvailable = true;
    }
}

