/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.utility;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.time.Instant;

public class CommonUtils {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private CommonUtils() {
    }

    @Nullable
    public static byte[] getNormalisedStringBytes(String s) {
        if (s == null) {
            return null;
        }
        return Normalizer.normalize(s, Normalizer.Form.NFD).getBytes(DEFAULT_CHARSET);
    }

    @NonNull
    public static String getNormalisedStringFromBytes(byte[] bytes) {
        return new String(bytes, DEFAULT_CHARSET);
    }

    @NonNull
    public static String hex(@Nullable byte[] bytes, int length) {
        if (bytes == null) {
            return "null";
        }
        CommonUtils.throwRangeInvalid("length", length, 0, bytes.length);
        char[] out = new char[length << 1];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            out[j++] = DIGITS_LOWER[(0xF0 & bytes[i]) >>> 4];
            out[j++] = DIGITS_LOWER[0xF & bytes[i]];
        }
        return new String(out);
    }

    @NonNull
    public static String hex(@Nullable Bytes bytes, int length) {
        if (bytes == null) {
            return "null";
        }
        CommonUtils.throwRangeInvalid("length", length, 0, (int)bytes.length());
        char[] out = new char[length << 1];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            out[j++] = DIGITS_LOWER[(0xF0 & bytes.getByte((long)i)) >>> 4];
            out[j++] = DIGITS_LOWER[0xF & bytes.getByte((long)i)];
        }
        return new String(out);
    }

    @NonNull
    public static String hex(@Nullable Bytes bytes) {
        return CommonUtils.hex(bytes, bytes == null ? 0 : Math.toIntExact(bytes.length()));
    }

    @NonNull
    public static String hex(@Nullable byte[] bytes) {
        return CommonUtils.hex(bytes, bytes == null ? 0 : bytes.length);
    }

    @Nullable
    public static byte[] unhex(@Nullable String string) {
        if (string == null) {
            return null;
        }
        char[] data = string.toCharArray();
        int len = data.length;
        if ((len & 1) != 0) {
            throw new IllegalArgumentException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = CommonUtils.toDigit(data[j], j) << 4;
            f |= CommonUtils.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    @Nullable
    public static Timestamp toPbjTimestamp(@Nullable Instant instant) {
        if (instant == null) {
            return null;
        }
        return new Timestamp(instant.getEpochSecond(), instant.getNano());
    }

    @Nullable
    public static Instant fromPbjTimestamp(@Nullable Timestamp timestamp) {
        return timestamp == null ? null : Instant.ofEpochSecond(timestamp.seconds(), timestamp.nanos());
    }

    private static int toDigit(char ch, int index) throws IllegalArgumentException {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    private static void throwRangeInvalid(String name, int value, int minValue, int maxValue) {
        if (value < minValue || value > maxValue) {
            throw new IllegalArgumentException(String.format("The argument '%s' should have a value between %d and %d! Value provided is %d", name, minValue, maxValue, value));
        }
    }
}

