/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime.hashing;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;

public class XXH3_64 {
    public static final XXH3_64 DEFAULT_INSTANCE = new XXH3_64(0L);
    private static final VarHandle LONG_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle INT_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    private static final int BLOCK_LEN_EXP = 10;
    private static final long SECRET_00 = -4734510112055689544L;
    private static final long SECRET_01 = 2066345149520216444L;
    private static final long SECRET_02 = -2623469361688619810L;
    private static final long SECRET_03 = 2262974939099578482L;
    private static final long SECRET_04 = 8711581037947681227L;
    private static final long SECRET_05 = 2410270004345854594L;
    private static final long SECRET_06 = -8204357891075471176L;
    private static final long SECRET_07 = 5487137525590930912L;
    private static final long SECRET_08 = -3818837453329782724L;
    private static final long SECRET_09 = -6688317018830679928L;
    private static final long SECRET_10 = 5690594596133299313L;
    private static final long SECRET_11 = -2833645246901970632L;
    private static final long SECRET_12 = 4554437623014685352L;
    private static final long SECRET_13 = 2111919702937427193L;
    private static final long SECRET_14 = 3556072174620004746L;
    private static final long SECRET_15 = 7238261902898274248L;
    private static final long SECRET_16 = -4329134394285701654L;
    private static final long SECRET_17 = -1485321483350670907L;
    private static final long SECRET_18 = 5321830579834785047L;
    private static final long SECRET_19 = -7032137544937171245L;
    private static final long SECRET_20 = -242834301215959509L;
    private static final long SECRET_21 = -3588858202114426737L;
    private static final long SECRET_22 = 2883454493032893253L;
    private static final long SECRET_23 = 9097354517224871855L;
    private static final long INIT_ACC_0 = 3266489917L;
    private static final long INIT_ACC_1 = -7046029288634856825L;
    private static final long INIT_ACC_2 = -4417276706812531889L;
    private static final long INIT_ACC_3 = 1609587929392839161L;
    private static final long INIT_ACC_4 = -8796714831421723037L;
    private static final long INIT_ACC_5 = 2246822519L;
    private static final long INIT_ACC_6 = 2870177450012600261L;
    private static final long INIT_ACC_7 = 2654435761L;
    private final long secret00;
    private final long secret01;
    private final long secret02;
    private final long secret03;
    private final long secret04;
    private final long secret05;
    private final long secret06;
    private final long secret07;
    private final long secret08;
    private final long secret09;
    private final long secret10;
    private final long secret11;
    private final long secret12;
    private final long secret13;
    private final long secret14;
    private final long secret15;
    private final long secret16;
    private final long secret17;
    private final long secret18;
    private final long secret19;
    private final long secret20;
    private final long secret21;
    private final long secret22;
    private final long secret23;
    private final long[] secret;
    private final long secShift00;
    private final long secShift01;
    private final long secShift02;
    private final long secShift03;
    private final long secShift04;
    private final long secShift05;
    private final long secShift06;
    private final long secShift07;
    private final long secShift08;
    private final long secShift09;
    private final long secShift10;
    private final long secShift11;
    private final long secShift16;
    private final long secShift17;
    private final long secShift18;
    private final long secShift19;
    private final long secShift20;
    private final long secShift21;
    private final long secShift22;
    private final long secShift23;
    private final long secShiftFinal0;
    private final long secShiftFinal1;
    private final long secShiftFinal2;
    private final long secShiftFinal3;
    private final long secShiftFinal4;
    private final long secShiftFinal5;
    private final long secShiftFinal6;
    private final long secShiftFinal7;
    private final long secShift12;
    private final long secShift13;
    private final long secShift14;
    private final long secShift15;
    private final long bitflip00;
    private final long bitflip12;
    private final long bitflip34;
    private final long bitflip56;
    private final long hash0;

    private XXH3_64(long seed) {
        this.secret00 = -4734510112055689544L + seed;
        this.secret01 = 2066345149520216444L - seed;
        this.secret02 = -2623469361688619810L + seed;
        this.secret03 = 2262974939099578482L - seed;
        this.secret04 = 8711581037947681227L + seed;
        this.secret05 = 2410270004345854594L - seed;
        this.secret06 = -8204357891075471176L + seed;
        this.secret07 = 5487137525590930912L - seed;
        this.secret08 = -3818837453329782724L + seed;
        this.secret09 = -6688317018830679928L - seed;
        this.secret10 = 5690594596133299313L + seed;
        this.secret11 = -2833645246901970632L - seed;
        this.secret12 = 4554437623014685352L + seed;
        this.secret13 = 2111919702937427193L - seed;
        this.secret14 = 3556072174620004746L + seed;
        this.secret15 = 7238261902898274248L - seed;
        this.secret16 = -4329134394285701654L + seed;
        this.secret17 = -1485321483350670907L - seed;
        this.secret18 = 5321830579834785047L + seed;
        this.secret19 = -7032137544937171245L - seed;
        this.secret20 = -242834301215959509L + seed;
        this.secret21 = -3588858202114426737L - seed;
        this.secret22 = 2883454493032893253L + seed;
        this.secret23 = 9097354517224871855L - seed;
        this.secShift00 = -9150895811085458631L + seed;
        this.secShift01 = 7914194659941938988L - seed;
        this.secShift02 = -6611157965513653271L + seed;
        this.secShift03 = -1839215637059881052L - seed;
        this.secShift04 = -3433288310154277810L + seed;
        this.secShift05 = 5046485836271438973L - seed;
        this.secShift06 = -8055285457383852172L + seed;
        this.secShift07 = 5920048007935066598L - seed;
        this.secShift08 = 7336514198459093435L + seed;
        this.secShift09 = 5216419214072683403L - seed;
        this.secShift10 = -1217880312389983593L + seed;
        this.secShift11 = 8573350489219836230L - seed;
        this.secShift16 = this.secret15 >>> 8 | this.secret16 << 56;
        this.secShift17 = this.secret16 >>> 8 | this.secret17 << 56;
        this.secShift18 = this.secret17 >>> 8 | this.secret18 << 56;
        this.secShift19 = this.secret18 >>> 8 | this.secret19 << 56;
        this.secShift20 = this.secret19 >>> 8 | this.secret20 << 56;
        this.secShift21 = this.secret20 >>> 8 | this.secret21 << 56;
        this.secShift22 = this.secret21 >>> 8 | this.secret22 << 56;
        this.secShift23 = this.secret22 >>> 8 | this.secret23 << 56;
        this.secShiftFinal0 = this.secret01 >>> 24 | this.secret02 << 40;
        this.secShiftFinal1 = this.secret02 >>> 24 | this.secret03 << 40;
        this.secShiftFinal2 = this.secret03 >>> 24 | this.secret04 << 40;
        this.secShiftFinal3 = this.secret04 >>> 24 | this.secret05 << 40;
        this.secShiftFinal4 = this.secret05 >>> 24 | this.secret06 << 40;
        this.secShiftFinal5 = this.secret06 >>> 24 | this.secret07 << 40;
        this.secShiftFinal6 = this.secret07 >>> 24 | this.secret08 << 40;
        this.secShiftFinal7 = this.secret08 >>> 24 | this.secret09 << 40;
        this.secret = new long[]{this.secret00, this.secret01, this.secret02, this.secret03, this.secret04, this.secret05, this.secret06, this.secret07, this.secret08, this.secret09, this.secret10, this.secret11, this.secret12, this.secret13, this.secret14, this.secret15, this.secret16, this.secret17, this.secret18, this.secret19, this.secret20, this.secret21, this.secret22, this.secret23};
        this.secShift12 = -4909775443879730369L + seed;
        this.secShift13 = -2282891677615274041L - seed;
        this.secShift14 = 8320639771003045937L + seed;
        this.secShift15 = -1453760514566526364L - seed;
        this.bitflip00 = 2267503259L + seed;
        this.bitflip12 = -4090762196417718878L - (seed ^ Long.reverseBytes(seed & 0xFFFFFFFFL));
        this.bitflip34 = 7458650908927343033L + seed;
        this.bitflip56 = -5812251307325107654L - seed;
        this.hash0 = XXH3_64.avalanche64(seed ^ 0x8726F9105DC21DDCL);
    }

    private static long rrmxmx(long h64, long length) {
        h64 ^= Long.rotateLeft(h64, 49) ^ Long.rotateLeft(h64, 24);
        h64 *= -6939452855193903323L;
        h64 ^= (h64 >>> 35) + length;
        return (h64 *= -6939452855193903323L) ^ h64 >>> 28;
    }

    private static long mix16B(byte[] input, int offIn, long sec0, long sec1) {
        long lo = LONG_HANDLE.get(input, offIn);
        long hi = LONG_HANDLE.get(input, offIn + 8);
        return XXH3_64.mix2Accs(lo, hi, sec0, sec1);
    }

    private static long avalanche64(long h64) {
        h64 ^= h64 >>> 33;
        h64 *= -4417276706812531889L;
        h64 ^= h64 >>> 29;
        return (h64 *= 1609587929392839161L) ^ h64 >>> 32;
    }

    private static long avalanche3(long h64) {
        h64 ^= h64 >>> 37;
        return (h64 *= 1609587791953885689L) ^ h64 >>> 32;
    }

    private static long mix2Accs(long lh, long rh, long sec0, long sec8) {
        return XXH3_64.mix(lh ^ sec0, rh ^ sec8);
    }

    private static long contrib(long a, long b) {
        long k = a ^ b;
        return (0xFFFFFFFFL & k) * (k >>> 32);
    }

    private static long mixAcc(long acc, long sec) {
        return (acc ^ acc >>> 47 ^ sec) * 2654435761L;
    }

    private static long mix(long a, long b) {
        long x = a * b;
        long y = Math.unsignedMultiplyHigh(a, b);
        return x ^ y;
    }

    public long hashBytesToLong(byte[] input, int off, int length) {
        long b7;
        long b6;
        long b5;
        long b4;
        long b3;
        long b2;
        long b1;
        long b0;
        int offStripe;
        int s;
        int offBlock;
        if (length <= 16) {
            if (length > 8) {
                long lo = LONG_HANDLE.get(input, off) ^ this.bitflip34;
                long hi = LONG_HANDLE.get(input, off + length - 8) ^ this.bitflip56;
                long acc = (long)length + Long.reverseBytes(lo) + hi + XXH3_64.mix(lo, hi);
                return XXH3_64.avalanche3(acc);
            }
            if (length >= 4) {
                long input1 = INT_HANDLE.get(input, off);
                long input2 = INT_HANDLE.get(input, off + length - 4);
                long keyed = input2 & 0xFFFFFFFFL ^ input1 << 32 ^ this.bitflip12;
                return XXH3_64.rrmxmx(keyed, length);
            }
            if (length != 0) {
                int c1 = input[off] & 0xFF;
                byte c2 = input[off + (length >> 1)];
                int c3 = input[off + length - 1] & 0xFF;
                long combined = ((long)(c1 << 16 | c2 << 24 | c3) | (long)length << 8) & 0xFFFFFFFFL;
                return XXH3_64.avalanche64(combined ^ this.bitflip00);
            }
            return this.hash0;
        }
        if (length <= 128) {
            long acc = (long)length * -7046029288634856825L;
            if (length > 32) {
                if (length > 64) {
                    if (length > 96) {
                        acc += XXH3_64.mix16B(input, off + 48, this.secret12, this.secret13);
                        acc += XXH3_64.mix16B(input, off + length - 64, this.secret14, this.secret15);
                    }
                    acc += XXH3_64.mix16B(input, off + 32, this.secret08, this.secret09);
                    acc += XXH3_64.mix16B(input, off + length - 48, this.secret10, this.secret11);
                }
                acc += XXH3_64.mix16B(input, off + 16, this.secret04, this.secret05);
                acc += XXH3_64.mix16B(input, off + length - 32, this.secret06, this.secret07);
            }
            acc += XXH3_64.mix16B(input, off, this.secret00, this.secret01);
            return XXH3_64.avalanche3(acc += XXH3_64.mix16B(input, off + length - 16, this.secret02, this.secret03));
        }
        if (length <= 240) {
            long acc = (long)length * -7046029288634856825L;
            acc += XXH3_64.mix16B(input, off, this.secret00, this.secret01);
            acc += XXH3_64.mix16B(input, off + 16, this.secret02, this.secret03);
            acc += XXH3_64.mix16B(input, off + 32, this.secret04, this.secret05);
            acc += XXH3_64.mix16B(input, off + 48, this.secret06, this.secret07);
            acc += XXH3_64.mix16B(input, off + 64, this.secret08, this.secret09);
            acc += XXH3_64.mix16B(input, off + 80, this.secret10, this.secret11);
            acc += XXH3_64.mix16B(input, off + 96, this.secret12, this.secret13);
            acc += XXH3_64.mix16B(input, off + 112, this.secret14, this.secret15);
            acc = XXH3_64.avalanche3(acc);
            if (length >= 144) {
                acc += XXH3_64.mix16B(input, off + 128, this.secShift00, this.secShift01);
                if (length >= 160) {
                    acc += XXH3_64.mix16B(input, off + 144, this.secShift02, this.secShift03);
                    if (length >= 176) {
                        acc += XXH3_64.mix16B(input, off + 160, this.secShift04, this.secShift05);
                        if (length >= 192) {
                            acc += XXH3_64.mix16B(input, off + 176, this.secShift06, this.secShift07);
                            if (length >= 208) {
                                acc += XXH3_64.mix16B(input, off + 192, this.secShift08, this.secShift09);
                                if (length >= 224) {
                                    acc += XXH3_64.mix16B(input, off + 208, this.secShift10, this.secShift11);
                                    if (length == 240) {
                                        acc += XXH3_64.mix16B(input, off + 224, this.secShift12, this.secShift13);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return XXH3_64.avalanche3(acc += XXH3_64.mix16B(input, off + length - 16, this.secShift14, this.secShift15));
        }
        long acc0 = 3266489917L;
        long acc1 = -7046029288634856825L;
        long acc2 = -4417276706812531889L;
        long acc3 = 1609587929392839161L;
        long acc4 = -8796714831421723037L;
        long acc5 = 2246822519L;
        long acc6 = 2870177450012600261L;
        long acc7 = 2654435761L;
        int nbBlocks = length - 1 >>> 10;
        for (int n = 0; n < nbBlocks; ++n) {
            offBlock = off + (n << 10);
            for (s = 0; s < 16; ++s) {
                offStripe = offBlock + (s << 6);
                b0 = LONG_HANDLE.get(input, offStripe);
                b1 = LONG_HANDLE.get(input, offStripe + 8);
                b2 = LONG_HANDLE.get(input, offStripe + 16);
                b3 = LONG_HANDLE.get(input, offStripe + 24);
                b4 = LONG_HANDLE.get(input, offStripe + 32);
                b5 = LONG_HANDLE.get(input, offStripe + 40);
                b6 = LONG_HANDLE.get(input, offStripe + 48);
                b7 = LONG_HANDLE.get(input, offStripe + 56);
                acc0 += b1 + XXH3_64.contrib(b0, this.secret[s]);
                acc1 += b0 + XXH3_64.contrib(b1, this.secret[s + 1]);
                acc2 += b3 + XXH3_64.contrib(b2, this.secret[s + 2]);
                acc3 += b2 + XXH3_64.contrib(b3, this.secret[s + 3]);
                acc4 += b5 + XXH3_64.contrib(b4, this.secret[s + 4]);
                acc5 += b4 + XXH3_64.contrib(b5, this.secret[s + 5]);
                acc6 += b7 + XXH3_64.contrib(b6, this.secret[s + 6]);
                acc7 += b6 + XXH3_64.contrib(b7, this.secret[s + 7]);
            }
            acc0 = XXH3_64.mixAcc(acc0, this.secret16);
            acc1 = XXH3_64.mixAcc(acc1, this.secret17);
            acc2 = XXH3_64.mixAcc(acc2, this.secret18);
            acc3 = XXH3_64.mixAcc(acc3, this.secret19);
            acc4 = XXH3_64.mixAcc(acc4, this.secret20);
            acc5 = XXH3_64.mixAcc(acc5, this.secret21);
            acc6 = XXH3_64.mixAcc(acc6, this.secret22);
            acc7 = XXH3_64.mixAcc(acc7, this.secret23);
        }
        int nbStripes = length - 1 - (nbBlocks << 10) >>> 6;
        offBlock = off + (nbBlocks << 10);
        for (s = 0; s < nbStripes; ++s) {
            offStripe = offBlock + (s << 6);
            b0 = LONG_HANDLE.get(input, offStripe);
            b1 = LONG_HANDLE.get(input, offStripe + 8);
            b2 = LONG_HANDLE.get(input, offStripe + 16);
            b3 = LONG_HANDLE.get(input, offStripe + 24);
            b4 = LONG_HANDLE.get(input, offStripe + 32);
            b5 = LONG_HANDLE.get(input, offStripe + 40);
            b6 = LONG_HANDLE.get(input, offStripe + 48);
            b7 = LONG_HANDLE.get(input, offStripe + 56);
            acc0 += b1 + XXH3_64.contrib(b0, this.secret[s]);
            acc1 += b0 + XXH3_64.contrib(b1, this.secret[s + 1]);
            acc2 += b3 + XXH3_64.contrib(b2, this.secret[s + 2]);
            acc3 += b2 + XXH3_64.contrib(b3, this.secret[s + 3]);
            acc4 += b5 + XXH3_64.contrib(b4, this.secret[s + 4]);
            acc5 += b4 + XXH3_64.contrib(b5, this.secret[s + 5]);
            acc6 += b7 + XXH3_64.contrib(b6, this.secret[s + 6]);
            acc7 += b6 + XXH3_64.contrib(b7, this.secret[s + 7]);
        }
        int offStripe2 = off + length - 64;
        long b02 = LONG_HANDLE.get(input, offStripe2);
        long b12 = LONG_HANDLE.get(input, offStripe2 + 8);
        long b22 = LONG_HANDLE.get(input, offStripe2 + 16);
        long b32 = LONG_HANDLE.get(input, offStripe2 + 24);
        long b42 = LONG_HANDLE.get(input, offStripe2 + 32);
        long b52 = LONG_HANDLE.get(input, offStripe2 + 40);
        long b62 = LONG_HANDLE.get(input, offStripe2 + 48);
        long b72 = LONG_HANDLE.get(input, offStripe2 + 56);
        return this.finalizeHash(length, acc0 += b12 + XXH3_64.contrib(b02, this.secShift16), acc1 += b02 + XXH3_64.contrib(b12, this.secShift17), acc2 += b32 + XXH3_64.contrib(b22, this.secShift18), acc3 += b22 + XXH3_64.contrib(b32, this.secShift19), acc4 += b52 + XXH3_64.contrib(b42, this.secShift20), acc5 += b42 + XXH3_64.contrib(b52, this.secShift21), acc6 += b72 + XXH3_64.contrib(b62, this.secShift22), acc7 += b62 + XXH3_64.contrib(b72, this.secShift23));
    }

    private long finalizeHash(long length, long acc0, long acc1, long acc2, long acc3, long acc4, long acc5, long acc6, long acc7) {
        long result64 = length * -7046029288634856825L + XXH3_64.mix2Accs(acc0, acc1, this.secShiftFinal0, this.secShiftFinal1) + XXH3_64.mix2Accs(acc2, acc3, this.secShiftFinal2, this.secShiftFinal3) + XXH3_64.mix2Accs(acc4, acc5, this.secShiftFinal4, this.secShiftFinal5) + XXH3_64.mix2Accs(acc6, acc7, this.secShiftFinal6, this.secShiftFinal7);
        return XXH3_64.avalanche3(result64);
    }
}

