/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.test.fixtures;

import com.swirlds.state.spi.WritableKVStateBase;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class MapWritableKVState<K, V>
extends WritableKVStateBase<K, V> {
    private final Map<K, V> backingStore;

    public MapWritableKVState(@NonNull String serviceName, @NonNull String stateKey) {
        this(serviceName, stateKey, new HashMap());
    }

    public MapWritableKVState(@NonNull String serviceName, @NonNull String stateKey, @NonNull Map<K, V> backingStore) {
        super(serviceName, stateKey);
        this.backingStore = Objects.requireNonNull(backingStore);
    }

    protected V readFromDataSource(@NonNull K key) {
        return this.backingStore.get(key);
    }

    @NonNull
    protected Iterator<K> iterateFromDataSource() {
        return this.backingStore.keySet().iterator();
    }

    protected void putIntoDataSource(@NonNull K key, @NonNull V value) {
        this.backingStore.put(key, value);
    }

    protected void removeFromDataSource(@NonNull K key) {
        this.backingStore.remove(key);
    }

    public Map<K, V> getBackingStore() {
        return this.backingStore;
    }

    @NonNull
    public long sizeOfDataSource() {
        return this.backingStore.size();
    }

    public String toString() {
        return "MapWritableKVState{backingStore=" + String.valueOf(this.backingStore) + "}";
    }

    public static <K, V> Builder<K, V> builder(@NonNull String serviceName, @NonNull String stateKey) {
        return new Builder(serviceName, stateKey);
    }

    public static final class Builder<K, V> {
        private final Map<K, V> backingStore = new HashMap();
        private final String serviceName;
        private final String stateKey;

        public Builder(@NonNull String serviceName, @NonNull String stateKey) {
            this.serviceName = serviceName;
            this.stateKey = stateKey;
        }

        public Builder<K, V> value(@NonNull K key, @Nullable V value) {
            this.backingStore.put(key, value);
            return this;
        }

        public MapWritableKVState<K, V> build() {
            return new MapWritableKVState<K, V>(this.serviceName, this.stateKey, new HashMap<K, V>(this.backingStore));
        }
    }
}

