/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.extensions.test.fixtures;

import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.config.api.converter.ConfigConverter;
import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.config.api.validation.ConfigValidator;
import com.swirlds.config.extensions.sources.SimpleConfigSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import org.hiero.base.concurrent.locks.AutoClosableLock;
import org.hiero.base.concurrent.locks.Locks;
import org.hiero.base.concurrent.locks.locked.Locked;

public class TestConfigBuilder {
    private final AutoClosableLock configLock = Locks.createAutoLock();
    private Configuration configuration = null;
    private final ConfigurationBuilder builder;

    public TestConfigBuilder() {
        this(true);
    }

    public TestConfigBuilder(@Nullable Class<? extends Record> dataTypes) {
        this(false);
        if (dataTypes != null) {
            this.builder.withConfigDataTypes(new Class[]{dataTypes});
        }
    }

    public TestConfigBuilder(boolean registerAllTypes) {
        this.builder = registerAllTypes ? ConfigurationBuilder.create().autoDiscoverExtensions() : ConfigurationBuilder.create();
    }

    @NonNull
    public TestConfigBuilder withValues(@NonNull String propertyName, @Nullable List<?> values) {
        return this.withSource((ConfigSource)new SimpleConfigSource(propertyName, values));
    }

    @NonNull
    public TestConfigBuilder withValue(@NonNull String propertyName, @Nullable String value) {
        return this.withSource((ConfigSource)new SimpleConfigSource(propertyName, value));
    }

    @NonNull
    public TestConfigBuilder withValue(@NonNull String propertyName, int value) {
        return this.withSource((ConfigSource)new SimpleConfigSource(propertyName, Integer.valueOf(value)));
    }

    @NonNull
    public TestConfigBuilder withValue(@NonNull String propertyName, double value) {
        return this.withSource((ConfigSource)new SimpleConfigSource(propertyName, Double.valueOf(value)));
    }

    @NonNull
    public TestConfigBuilder withValue(@NonNull String propertyName, long value) {
        return this.withSource((ConfigSource)new SimpleConfigSource(propertyName, Long.valueOf(value)));
    }

    @NonNull
    public TestConfigBuilder withValue(@NonNull String propertyName, boolean value) {
        return this.withSource((ConfigSource)new SimpleConfigSource(propertyName, Boolean.valueOf(value)));
    }

    @NonNull
    public TestConfigBuilder withValue(@NonNull String propertyName, @NonNull Object value) {
        Objects.requireNonNull(value, "value must not be null");
        return this.withSource((ConfigSource)new SimpleConfigSource(propertyName, value.toString()));
    }

    @NonNull
    public Configuration getOrCreateConfig() {
        try (Locked ignore = this.configLock.lock();){
            if (this.configuration == null) {
                this.configuration = this.builder.build();
            }
            Configuration configuration = this.configuration;
            return configuration;
        }
    }

    private void checkConfigState() {
        try (Locked ignore = this.configLock.lock();){
            if (this.configuration != null) {
                throw new IllegalStateException("Configuration already created!");
            }
        }
    }

    @NonNull
    public TestConfigBuilder withSource(@NonNull ConfigSource configSource) {
        this.checkConfigState();
        this.builder.withSource(configSource);
        return this;
    }

    @NonNull
    public <T> TestConfigBuilder withConverter(@NonNull Class<T> converterType, @NonNull ConfigConverter<T> converter) {
        this.checkConfigState();
        this.builder.withConverter(converterType, converter);
        return this;
    }

    @NonNull
    public TestConfigBuilder withValidator(@NonNull ConfigValidator validator) {
        this.checkConfigState();
        this.builder.withValidator(validator);
        return this;
    }

    @NonNull
    public <T extends Record> TestConfigBuilder withConfigDataType(@NonNull Class<T> type) {
        this.checkConfigState();
        this.builder.withConfigDataType(type);
        return this;
    }
}

