/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform.actions;

import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.impl.PartialMerkleLeaf;
import com.swirlds.demo.platform.actions.Action;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class QuorumResult<S extends SelfSerializable>
extends PartialMerkleLeaf
implements MerkleLeaf {
    public static final long CLASS_ID = 6401444178458397638L;
    private final AtomicBoolean quorum;
    private final AtomicReference<S> quorumState;
    private AtomicReferenceArray<S> lastResultValues;

    public QuorumResult() {
        this.quorum = new AtomicBoolean();
        this.quorumState = new AtomicReference();
    }

    public QuorumResult(int size) {
        this.quorum = new AtomicBoolean();
        this.quorumState = new AtomicReference();
        this.lastResultValues = new AtomicReferenceArray(size);
    }

    public QuorumResult(boolean quorum, S quorumState, AtomicReferenceArray<S> newValues) {
        this.quorum = new AtomicBoolean(quorum);
        this.quorumState = new AtomicReference<S>(quorumState);
        this.lastResultValues = new AtomicReferenceArray(newValues.length());
        for (int i = 0; i < newValues.length(); ++i) {
            this.lastResultValues.getAndSet(i, (SelfSerializable)newValues.get(i));
        }
    }

    public boolean hasQuorum() {
        return this.quorum.get();
    }

    public S getQuorumState() {
        return (S)((SelfSerializable)this.quorumState.get());
    }

    public void reset() {
        this.quorum.set(false);
        this.quorumState.set(null);
        for (int i = 0; i < this.lastResultValues.length(); ++i) {
            this.lastResultValues.set(i, null);
        }
    }

    public boolean checkForQuorum(S value, int quorumThreshold, long selfId, Action<Long, S> lostQuorumAction) {
        int membersInAgreement = 0;
        for (int i = 0; i < this.lastResultValues.length(); ++i) {
            SelfSerializable nodeValue = (SelfSerializable)this.lastResultValues.get(i);
            if (!Objects.equals(value, nodeValue)) continue;
            ++membersInAgreement;
        }
        boolean newQuorum = membersInAgreement >= quorumThreshold;
        boolean oldQuorum = this.quorum.getAndSet(newQuorum);
        if (oldQuorum && !newQuorum) {
            this.quorumState.set(null);
            if (lostQuorumAction != null) {
                lostQuorumAction.execute(selfId, value);
            }
        } else if (newQuorum) {
            this.quorumState.set(value);
        }
        return this.quorum.get();
    }

    public boolean applyTransition(Long node, S state, int quorumThreshold, long selfId, Action<Long, S> lostQuorumAction) {
        SelfSerializable oldValue = (SelfSerializable)this.lastResultValues.getAndSet(node.intValue(), state);
        if (Objects.equals(oldValue, state)) {
            return false;
        }
        return this.checkForQuorum(state, quorumThreshold, selfId, lostQuorumAction);
    }

    public long getClassId() {
        return 6401444178458397638L;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeBoolean(this.quorum.get());
        out.writeSerializable((SelfSerializable)this.quorumState.get(), true);
        out.writeInt(this.lastResultValues.length());
        for (int i = 0; i < this.lastResultValues.length(); ++i) {
            out.writeSerializable((SelfSerializable)this.lastResultValues.get(i), true);
        }
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.quorum.getAndSet(in.readBoolean());
        this.quorumState.getAndSet(in.readSerializable());
        this.lastResultValues = new AtomicReferenceArray(in.readInt());
        for (int i = 0; i < this.lastResultValues.length(); ++i) {
            this.lastResultValues.set(i, in.readSerializable());
        }
    }

    public int getVersion() {
        return 1;
    }

    public QuorumResult<S> copy() {
        return new QuorumResult<SelfSerializable>(this.quorum.get(), (SelfSerializable)this.quorumState.get(), this.lastResultValues);
    }

    public String toString() {
        return "QuorumResult{quorum=" + String.valueOf(this.quorum) + ", quorumState=" + String.valueOf(this.quorumState) + ", lastResultValues=" + String.valueOf(this.lastResultValues) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        QuorumResult that = (QuorumResult)((Object)o);
        if (!Objects.equals(this.quorum.get(), that.quorum.get())) {
            return false;
        }
        if (this.quorumState != null && that.quorumState != null && ((SelfSerializable)this.quorumState.get()).equals(that.quorumState.get())) {
            return true;
        }
        if (this.lastResultValues != null && that.lastResultValues != null && this.lastResultValues.length() == that.lastResultValues.length()) {
            for (int i = 0; i < this.lastResultValues.length(); ++i) {
                if (((SelfSerializable)this.lastResultValues.get(i)).equals(that.lastResultValues.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.quorum, this.quorumState, this.lastResultValues);
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

