/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.io;

import com.swirlds.common.test.fixtures.io.ResourceNotFoundException;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;

public abstract class ResourceLoader {
    private static final ClassLoader classLoader = ResourceLoader.class.getClassLoader();

    public static Path getFile(String path) throws URISyntaxException {
        URL resource = classLoader.getResource(path);
        ResourceLoader.checkIfFound(resource, path);
        URI uri = resource.toURI();
        ResourceLoader.checkIfFound(uri, path);
        File file = new File(uri);
        ResourceLoader.checkIfFound(file, path);
        return file.toPath();
    }

    private static void checkIfFound(Object toCheck, String path) {
        File f;
        String s;
        if (toCheck == null) {
            ResourceLoader.resourceNotFound(path);
        }
        if (toCheck instanceof String && (s = (String)toCheck).isEmpty()) {
            ResourceLoader.resourceNotFound(path);
        }
        if (toCheck instanceof File && !(f = (File)toCheck).exists()) {
            ResourceLoader.resourceNotFound(path);
        }
    }

    private static void resourceNotFound(String path) {
        URL url = classLoader.getResource(".");
        Object exPath = url != null ? url.getFile() + path : path;
        throw new ResourceNotFoundException((String)exPath);
    }

    public static URL loadURL(String path) {
        URL url = classLoader.getResource(path);
        ResourceLoader.checkIfFound(url, path);
        return url;
    }

    public static File searchForFile(String fileName, List<String> possibleLocations) throws FileNotFoundException {
        for (String possibleLocation : possibleLocations) {
            Path path = Paths.get(possibleLocation, fileName);
            File file = new File(path.toUri());
            if (!file.exists()) continue;
            return file;
        }
        StringBuilder sb = new StringBuilder("Unable to find file ").append(fileName).append(" in any of the following locations:\n");
        for (String possibleLocation : possibleLocations) {
            Path path = Paths.get(possibleLocation, fileName);
            File file = new File(path.toUri());
            sb.append(file).append("\n");
        }
        throw new FileNotFoundException(sb.toString());
    }

    public static File searchForLog4jConfig() throws FileNotFoundException {
        return ResourceLoader.searchForFile("log4j2-test.xml", Arrays.asList("src/test/resources", "../../../swirlds-platform-core/src/test/resources", "../swirlds-platform-core/src/test/resources", "swirlds-platform-core/src/test/java/main/resources"));
    }

    public static void loadLog4jContext() throws FileNotFoundException {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        File log4jConfig = ResourceLoader.searchForLog4jConfig();
        context.setConfigLocation(log4jConfig.toURI());
    }
}

