/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.consensus.framework.validation;

import com.swirlds.platform.test.fixtures.consensus.framework.ConsensusOutput;
import com.swirlds.platform.test.fixtures.consensus.framework.validation.ConsensusOutputValidation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.LinkedList;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.Assertions;
import org.hiero.consensus.model.event.PlatformEvent;

public class OutputEventRatioValidation
implements ConsensusOutputValidation {
    private double minimumConsensusRatio;
    private double maximumConsensusRatio;
    private double minimumStaleRatio;
    private double maximumStaleRatio;

    private OutputEventRatioValidation(double minimumConsensusRatio, double maximumConsensusRatio, double minimumStaleRatio, double maximumStaleRatio) {
        this.minimumConsensusRatio = minimumConsensusRatio;
        this.maximumConsensusRatio = maximumConsensusRatio;
        this.minimumStaleRatio = minimumStaleRatio;
        this.maximumStaleRatio = maximumStaleRatio;
    }

    @NonNull
    public static OutputEventRatioValidation blank() {
        return new OutputEventRatioValidation(0.0, Double.MAX_VALUE, 0.0, Double.MAX_VALUE);
    }

    @NonNull
    public static OutputEventRatioValidation standard() {
        return new OutputEventRatioValidation(0.8, 1.0, 0.0, 0.01);
    }

    @NonNull
    public OutputEventRatioValidation setMinimumConsensusRatio(double expectedConsensusRatio) {
        this.minimumConsensusRatio = expectedConsensusRatio;
        return this;
    }

    @NonNull
    public OutputEventRatioValidation setMaximumConsensusRatio(double maximumConsensusRatio) {
        this.maximumConsensusRatio = maximumConsensusRatio;
        return this;
    }

    @NonNull
    public OutputEventRatioValidation setMinimumStaleRatio(double minimumStaleRatio) {
        this.minimumStaleRatio = minimumStaleRatio;
        return this;
    }

    @NonNull
    public OutputEventRatioValidation setMaximumStaleRatio(double maximumStaleRatio) {
        this.maximumStaleRatio = maximumStaleRatio;
        return this;
    }

    @Override
    public void validate(@NonNull ConsensusOutput output1, @NonNull ConsensusOutput ignored) {
        LinkedList<PlatformEvent> allEvents1 = output1.getAddedEvents();
        int numConsensus = output1.getConsensusRounds().stream().mapToInt(r -> r.getConsensusEvents().size()).sum();
        if (allEvents1.isEmpty()) {
            return;
        }
        double consensusRatio = (double)numConsensus / (double)allEvents1.size();
        ((AbstractDoubleAssert)Assertions.assertThat((double)consensusRatio).withFailMessage(String.format("Consensus ratio %s is less than the expected minimum %s", consensusRatio, this.minimumConsensusRatio), new Object[0])).isGreaterThanOrEqualTo(this.minimumConsensusRatio);
        ((AbstractDoubleAssert)Assertions.assertThat((double)consensusRatio).withFailMessage(String.format("Consensus ratio %s is more than the expected maximum %s", consensusRatio, this.maximumConsensusRatio), new Object[0])).isLessThanOrEqualTo(this.maximumConsensusRatio);
        double staleRatio = (double)output1.getStaleEvents().size() / (double)allEvents1.size();
        ((AbstractDoubleAssert)Assertions.assertThat((double)staleRatio).withFailMessage(String.format("Stale ratio %s is less than the expected minimum %s", staleRatio, this.minimumStaleRatio), new Object[0])).isGreaterThanOrEqualTo(this.minimumStaleRatio);
        ((AbstractDoubleAssert)Assertions.assertThat((double)staleRatio).withFailMessage(String.format("Stale ratio %s is more than the expected maximum %s", staleRatio, this.maximumStaleRatio), new Object[0])).isLessThanOrEqualTo(this.maximumStaleRatio);
    }
}

