/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.event;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.utility.RecycleBin;
import com.swirlds.common.test.fixtures.TransactionGenerator;
import com.swirlds.common.units.DataUnit;
import com.swirlds.config.api.Configuration;
import com.swirlds.platform.event.preconsensus.PcesFile;
import com.swirlds.platform.event.preconsensus.PcesFileIterator;
import com.swirlds.platform.event.preconsensus.PcesFileReader;
import com.swirlds.platform.event.preconsensus.PcesFileTracker;
import com.swirlds.platform.event.preconsensus.PcesMultiFileIterator;
import com.swirlds.platform.system.transaction.TransactionWrapperUtils;
import com.swirlds.platform.test.fixtures.event.generator.StandardGraphGenerator;
import com.swirlds.platform.test.fixtures.event.source.StandardEventSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.hiero.base.CompareTo;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.transaction.TransactionWrapper;
import org.junit.jupiter.api.Assertions;

public class PcesWriterTestUtils {
    private PcesWriterTestUtils() {
    }

    public static TransactionGenerator buildTransactionGenerator() {
        int transactionCount = 10;
        int averageTransactionSizeInKb = 10;
        int transactionSizeStandardDeviationInKb = 5;
        return random -> {
            TransactionWrapper[] transactions = new TransactionWrapper[10];
            for (int index = 0; index < 10; ++index) {
                int transactionSize = (int)DataUnit.UNIT_KILOBYTES.convertTo(Math.max(1.0, 10.0 + random.nextDouble() * 5.0), DataUnit.UNIT_BYTES);
                byte[] bytes = new byte[transactionSize];
                random.nextBytes(bytes);
                transactions[index] = TransactionWrapperUtils.createAppPayloadWrapper((byte[])bytes);
            }
            return transactions;
        };
    }

    public static StandardGraphGenerator buildGraphGenerator(@NonNull PlatformContext platformContext, @NonNull Random random) {
        Objects.requireNonNull(platformContext);
        TransactionGenerator transactionGenerator = PcesWriterTestUtils.buildTransactionGenerator();
        return new StandardGraphGenerator(platformContext, random.nextLong(), new StandardEventSource().setTransactionGenerator(transactionGenerator), new StandardEventSource().setTransactionGenerator(transactionGenerator), new StandardEventSource().setTransactionGenerator(transactionGenerator), new StandardEventSource().setTransactionGenerator(transactionGenerator));
    }

    public static void verifyStream(@NonNull Path pcesDirectory, @NonNull List<PlatformEvent> events, @NonNull PlatformContext platformContext, int truncatedFileCount) throws IOException {
        long lastAncientIdentifier = Long.MIN_VALUE;
        for (PlatformEvent event : events) {
            lastAncientIdentifier = Math.max(lastAncientIdentifier, event.getBirthRound());
        }
        PcesFileTracker pcesFiles = PcesFileReader.readFilesFromDisk((Configuration)platformContext.getConfiguration(), (RecycleBin)platformContext.getRecycleBin(), (Path)pcesDirectory, (long)0L, (boolean)false);
        PcesMultiFileIterator eventsIterator = pcesFiles.getEventIterator(0L, 0L);
        int index = 0;
        for (PlatformEvent event : events) {
            Assertions.assertTrue((boolean)eventsIterator.hasNext(), (String)"Event with index %d was not found, %d events are expected".formatted(index, events.size()));
            Assertions.assertEquals((Object)event, (Object)eventsIterator.next());
            ++index;
        }
        Assertions.assertFalse((boolean)eventsIterator.hasNext(), (String)"There should be no more events");
        Assertions.assertEquals((int)truncatedFileCount, (int)eventsIterator.getTruncatedFileCount());
        long startingLowerBound = lastAncientIdentifier / 2L;
        PcesMultiFileIterator eventsIterator2 = pcesFiles.getEventIterator(startingLowerBound, 0L);
        for (PlatformEvent event : events) {
            if (event.getBirthRound() < startingLowerBound) continue;
            Assertions.assertTrue((boolean)eventsIterator2.hasNext());
            Assertions.assertEquals((Object)event, (Object)eventsIterator2.next());
        }
        Assertions.assertFalse((boolean)eventsIterator2.hasNext());
        PcesMultiFileIterator eventsIterator3 = pcesFiles.getEventIterator(lastAncientIdentifier + 1L, 0L);
        Assertions.assertFalse((boolean)eventsIterator3.hasNext());
        ArrayList files = new ArrayList();
        pcesFiles.getFileIterator(0L, 0L).forEachRemaining(files::add);
        Assertions.assertTrue((files.size() >= 2 ? 1 : 0) != 0);
        int nextSequenceNumber = 0;
        Instant previousTimestamp = Instant.MIN;
        long previousMinimum = Long.MIN_VALUE;
        long previousMaximum = Long.MIN_VALUE;
        for (PcesFile file : files) {
            Assertions.assertEquals((long)nextSequenceNumber, (long)file.getSequenceNumber());
            ++nextSequenceNumber;
            Assertions.assertTrue((boolean)CompareTo.isGreaterThanOrEqualTo((Comparable)file.getTimestamp(), (Object)previousTimestamp));
            previousTimestamp = file.getTimestamp();
            Assertions.assertTrue((file.getLowerBound() <= file.getUpperBound() ? 1 : 0) != 0);
            Assertions.assertTrue((file.getLowerBound() >= previousMinimum ? 1 : 0) != 0);
            previousMinimum = file.getLowerBound();
            Assertions.assertTrue((file.getUpperBound() >= previousMaximum ? 1 : 0) != 0);
            previousMaximum = file.getUpperBound();
            try {
                PcesFileIterator fileEvents = file.iterator(0L);
                try {
                    while (fileEvents.hasNext()) {
                        PlatformEvent event = (PlatformEvent)fileEvents.next();
                        Assertions.assertTrue((event.getBirthRound() >= file.getLowerBound() ? 1 : 0) != 0);
                        Assertions.assertTrue((event.getBirthRound() <= file.getUpperBound() ? 1 : 0) != 0);
                    }
                }
                finally {
                    if (fileEvents == null) continue;
                    fileEvents.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

