/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.communication;

import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.gossip.sync.SyncInputStream;
import com.swirlds.platform.gossip.sync.SyncOutputStream;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.NetworkProtocolException;
import com.swirlds.platform.network.communication.NegotiationException;
import com.swirlds.platform.network.communication.NegotiationProtocols;
import com.swirlds.platform.network.communication.states.InitialState;
import com.swirlds.platform.network.communication.states.NegotiationState;
import com.swirlds.platform.network.communication.states.ProtocolNegotiated;
import com.swirlds.platform.network.communication.states.ReceivedInitiate;
import com.swirlds.platform.network.communication.states.SentInitiate;
import com.swirlds.platform.network.communication.states.SentKeepalive;
import com.swirlds.platform.network.communication.states.Sleep;
import com.swirlds.platform.network.communication.states.WaitForAcceptReject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Negotiator {
    private static final Logger logger = LogManager.getLogger(Negotiator.class);
    private final NegotiationProtocols protocols;
    private final NegotiationState initialState;
    private final ProtocolNegotiated protocolNegotiated;
    private final Sleep sleep;
    private boolean errorState;
    private final String negotiatorName;

    public Negotiator(NegotiationProtocols protocols, Connection connection, int sleepMs) {
        this.protocols = protocols;
        this.protocolNegotiated = new ProtocolNegotiated(connection);
        this.sleep = new Sleep(sleepMs);
        SyncInputStream in = connection.getDis();
        SyncOutputStream out = connection.getDos();
        ReceivedInitiate receivedInitiate = new ReceivedInitiate(protocols, (OutputStream)((Object)out), this.protocolNegotiated, this.sleep);
        WaitForAcceptReject waitForAcceptReject = new WaitForAcceptReject(protocols, (InputStream)((Object)in), this.protocolNegotiated, this.sleep);
        SentInitiate sentInitiate = new SentInitiate(protocols, (InputStream)((Object)in), this.protocolNegotiated, receivedInitiate, waitForAcceptReject, this.sleep);
        SentKeepalive sentKeepalive = new SentKeepalive((InputStream)((Object)in), this.sleep, receivedInitiate);
        this.initialState = new InitialState(protocols, (OutputStream)((Object)out), sentKeepalive, sentInitiate);
        this.errorState = false;
        this.negotiatorName = connection.getDescription();
    }

    public void execute() throws InterruptedException, NegotiationException, NetworkProtocolException, IOException {
        if (this.errorState) {
            throw new IllegalStateException();
        }
        NegotiationState prev = null;
        for (NegotiationState current = this.initialState; current != null; current = current.transition()) {
            try {
                prev = current;
                logger.debug(LogMarker.PROTOCOL_NEGOTIATION.getMarker(), "Negotiator {} last transition: {}", (Object)this.negotiatorName, (Object)prev.getLastTransitionDescription());
                continue;
            }
            catch (NetworkProtocolException | NegotiationException | IOException | InterruptedException | RuntimeException e) {
                this.errorState = true;
                this.protocols.negotiationExceptionOccurred();
                throw e;
            }
        }
        if (prev != this.sleep && prev != this.protocolNegotiated) {
            throw new NegotiationException("The outcome should always be sleep or running a protocol");
        }
    }
}

