/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.migration.virtual;

import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.virtualmap.VirtualValue;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class AccountVirtualMapValue
implements VirtualValue {
    private static final long CLASS_ID = -2987475432607502347L;
    private long balance;
    private long sendThreshold;
    private long receiveThreshold;
    private boolean requireSignature;
    private long uid;

    public AccountVirtualMapValue() {
        this(0L, 0L, 0L, false, 0L);
    }

    public AccountVirtualMapValue(long balance, long sendThreshold, long receiveThreshold, boolean requireSignature, long uid) {
        this.balance = balance;
        this.sendThreshold = sendThreshold;
        this.receiveThreshold = receiveThreshold;
        this.requireSignature = requireSignature;
        this.uid = uid;
    }

    public AccountVirtualMapValue(AccountVirtualMapValue accountVirtualMapValue) {
        this.balance = accountVirtualMapValue.balance;
        this.sendThreshold = accountVirtualMapValue.sendThreshold;
        this.receiveThreshold = accountVirtualMapValue.receiveThreshold;
        this.requireSignature = accountVirtualMapValue.requireSignature;
        this.uid = accountVirtualMapValue.uid;
    }

    public AccountVirtualMapValue(ReadableSequentialData in) {
        this.balance = in.readLong();
        this.sendThreshold = in.readLong();
        this.receiveThreshold = in.readLong();
        this.requireSignature = in.readByte() != 0;
        this.uid = in.readLong();
    }

    public Bytes toBytes() {
        byte[] bytes = new byte[33];
        ByteBuffer.wrap(bytes).putLong(this.balance).putLong(this.sendThreshold).putLong(this.receiveThreshold).put(this.getRequireSignatureAsByte()).putLong(this.uid);
        return Bytes.wrap((byte[])bytes);
    }

    public int getSizeInBytes() {
        return 33;
    }

    public void writeTo(WritableSequentialData out) {
        out.writeLong(this.balance);
        out.writeLong(this.sendThreshold);
        out.writeLong(this.receiveThreshold);
        out.writeByte(this.getRequireSignatureAsByte());
        out.writeLong(this.uid);
    }

    public int getVersion() {
        return 1;
    }

    public long getClassId() {
        return -2987475432607502347L;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.balance);
        out.writeLong(this.sendThreshold);
        out.writeLong(this.receiveThreshold);
        out.write((int)this.getRequireSignatureAsByte());
        out.writeLong(this.uid);
    }

    void serialize(WritableSequentialData out) {
        out.writeLong(this.balance);
        out.writeLong(this.sendThreshold);
        out.writeLong(this.receiveThreshold);
        out.writeByte(this.getRequireSignatureAsByte());
        out.writeLong(this.uid);
    }

    @Deprecated
    void serialize(ByteBuffer buffer) {
        buffer.putLong(this.balance);
        buffer.putLong(this.sendThreshold);
        buffer.putLong(this.receiveThreshold);
        buffer.put(this.getRequireSignatureAsByte());
        buffer.putLong(this.uid);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.balance = in.readLong();
        this.sendThreshold = in.readLong();
        this.receiveThreshold = in.readLong();
        this.requireSignature = in.readByte() == 1;
        this.uid = in.readLong();
    }

    void deserialize(ReadableSequentialData in) {
        this.balance = in.readLong();
        this.sendThreshold = in.readLong();
        this.receiveThreshold = in.readLong();
        this.requireSignature = in.readByte() == 1;
        this.uid = in.readLong();
    }

    @Deprecated
    void deserialize(ByteBuffer buffer, int version) {
        this.balance = buffer.getLong();
        this.sendThreshold = buffer.getLong();
        this.receiveThreshold = buffer.getLong();
        this.requireSignature = buffer.get() == 1;
        this.uid = buffer.getLong();
    }

    public VirtualValue copy() {
        return new AccountVirtualMapValue(this);
    }

    public VirtualValue asReadOnly() {
        return new AccountVirtualMapValue(this);
    }

    public String toString() {
        return "AccountVirtualMapValue{balance=" + this.balance + ", sendThreshold=" + this.sendThreshold + ", receiveThreshold=" + this.receiveThreshold + ", requireSignature=" + this.requireSignature + ", uid=" + this.uid + "}";
    }

    private byte getRequireSignatureAsByte() {
        return (byte)(this.requireSignature ? 1 : 0);
    }

    public long getBalance() {
        return this.balance;
    }

    public long getSendThreshold() {
        return this.sendThreshold;
    }

    public long getReceiveThreshold() {
        return this.receiveThreshold;
    }

    public boolean isRequireSignature() {
        return this.requireSignature;
    }

    public long getUid() {
        return this.uid;
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

