/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base.utility;

import com.swirlds.base.utility.Retry;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutionException;

public final class NetworkUtils {
    public static final Duration DNS_RESOLUTION_WAIT_TIME = Duration.ofSeconds(60L);

    private NetworkUtils() {
    }

    public static boolean isNameResolvable(@NonNull String name) {
        return NetworkUtils.isNameResolvable(name, DNS_RESOLUTION_WAIT_TIME, Retry.DEFAULT_RETRY_DELAY);
    }

    public static boolean isNameResolvable(@NonNull String name, @NonNull Duration waitTime) {
        return NetworkUtils.isNameResolvable(name, waitTime, Retry.DEFAULT_RETRY_DELAY);
    }

    public static boolean isNameResolvable(@NonNull String name, @NonNull Duration waitTime, @NonNull Duration retryDelay) {
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(waitTime, "waitTime must not be null");
        Objects.requireNonNull(retryDelay, "retryDelay must not be null");
        try {
            return Retry.check(NetworkUtils::isNameResolvableInternal, name, waitTime, retryDelay);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static InetAddress resolveName(@NonNull String name) throws UnknownHostException {
        return NetworkUtils.resolveName(name, DNS_RESOLUTION_WAIT_TIME, Retry.DEFAULT_RETRY_DELAY);
    }

    public static InetAddress resolveName(@NonNull String name, @NonNull Duration waitTime) throws UnknownHostException {
        return NetworkUtils.resolveName(name, waitTime, Retry.DEFAULT_RETRY_DELAY);
    }

    public static InetAddress resolveName(@NonNull String name, @NonNull Duration waitTime, @NonNull Duration retryDelay) throws UnknownHostException {
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(waitTime, "waitTime must not be null");
        Objects.requireNonNull(retryDelay, "retryDelay must not be null");
        try {
            return Retry.resolve(InetAddress::getByName, name, waitTime, retryDelay);
        }
        catch (ExecutionException ex) {
            throw new UnknownHostException(name + ": Name or service not known");
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private static boolean isNameResolvableInternal(@NonNull String name) {
        Objects.requireNonNull(name, "name must not be null");
        try {
            InetAddress[] addresses = InetAddress.getAllByName(name);
            if (addresses != null && addresses.length > 0) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }
}

