/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.collections;

import com.swirlds.merkledb.collections.ImmutableIndexedObjectList;
import com.swirlds.merkledb.collections.IndexedObject;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public class ImmutableIndexedObjectListUsingArray<T extends IndexedObject>
implements ImmutableIndexedObjectList<T> {
    private final int firstIndexOffset;
    private final Function<Integer, T[]> arrayProvider;
    private final T[] dataArray;
    private final int size;

    public ImmutableIndexedObjectListUsingArray(@NonNull Function<Integer, T[]> arrProvider, @NonNull List<T> objects) {
        Objects.requireNonNull(arrProvider);
        Objects.requireNonNull(objects);
        this.arrayProvider = arrProvider;
        ArrayList<IndexedObject> nonNullObjects = new ArrayList<IndexedObject>();
        for (IndexedObject object : objects) {
            if (object == null) continue;
            nonNullObjects.add(object);
        }
        this.size = nonNullObjects.size();
        if (this.size == 0) {
            this.firstIndexOffset = 0;
            this.dataArray = null;
        } else {
            nonNullObjects.sort(Comparator.comparingInt(IndexedObject::getIndex));
            IndexedObject firstObject = (IndexedObject)nonNullObjects.get(0);
            this.firstIndexOffset = firstObject.getIndex();
            int lastIndex = ((IndexedObject)nonNullObjects.get(nonNullObjects.size() - 1)).getIndex();
            int range = lastIndex - this.firstIndexOffset + 1;
            this.dataArray = (IndexedObject[])this.arrayProvider.apply(range);
            for (IndexedObject object : nonNullObjects) {
                this.dataArray[object.getIndex() - this.firstIndexOffset] = object;
            }
        }
    }

    @Override
    public ImmutableIndexedObjectListUsingArray<T> withAddedObject(T newObject) {
        if (newObject == null) {
            return this;
        }
        ArrayList<T> newDataArray = new ArrayList<T>(Arrays.asList(this.dataArray));
        newDataArray.removeIf(next -> next == null || next.getIndex() == newObject.getIndex());
        newDataArray.add(newObject);
        return new ImmutableIndexedObjectListUsingArray<T>(this.arrayProvider, newDataArray);
    }

    @Override
    public ImmutableIndexedObjectListUsingArray<T> withDeletedObjects(@NonNull Collection<T> objectsToDelete) {
        if (objectsToDelete.isEmpty() || this.isEmpty()) {
            return this;
        }
        ArrayList<T> newDataArray = new ArrayList<T>();
        for (T datum : this.dataArray) {
            if (datum == null || objectsToDelete.contains(datum)) continue;
            newDataArray.add(datum);
        }
        return new ImmutableIndexedObjectListUsingArray(this.arrayProvider, newDataArray);
    }

    @Override
    public T getLast() {
        return this.isEmpty() ? null : (T)this.dataArray[this.dataArray.length - 1];
    }

    @Override
    public T get(int objectIndex) {
        if (objectIndex < 0) {
            throw new IndexOutOfBoundsException("Cannot use negative index " + objectIndex);
        }
        if (this.isEmpty()) {
            return null;
        }
        int offsetIndex = objectIndex - this.firstIndexOffset;
        return offsetIndex < 0 || offsetIndex >= this.dataArray.length ? null : (T)this.dataArray[offsetIndex];
    }

    @Override
    public Stream<T> stream() {
        return Arrays.stream(this.dataArray).filter(Objects::nonNull);
    }

    public String toString() {
        return this.prettyPrintedIndices();
    }

    private boolean isEmpty() {
        return this.dataArray == null;
    }

    @Override
    public int size() {
        return this.size;
    }
}

