/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.disk;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.swirlds.state.merkle.disk.OnDiskValue;
import com.swirlds.virtualmap.serialize.ValueSerializer;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Objects;

public final class OnDiskValueSerializer<V>
implements ValueSerializer<OnDiskValue<V>> {
    private static final long CLASS_ID = 4148397141160839302L;
    private static final int VERSION = 1;
    private static final int TYPICAL_SIZE = 1024;
    private final long serializerClassId;
    private final long valueClassId;
    private final Codec<V> codec;

    @Deprecated(forRemoval=true)
    public OnDiskValueSerializer() {
        this.codec = null;
        this.serializerClassId = 4148397141160839302L;
        this.valueClassId = 0L;
    }

    public OnDiskValueSerializer(long serializerClassId, long valueClassId, @NonNull Codec<V> codec) {
        this.codec = Objects.requireNonNull(codec);
        this.serializerClassId = serializerClassId;
        this.valueClassId = valueClassId;
    }

    public long getClassId() {
        return this.serializerClassId;
    }

    public int getVersion() {
        return 1;
    }

    public long getCurrentDataVersion() {
        return 1L;
    }

    public int getSerializedSize() {
        return -1;
    }

    public int getSerializedSize(OnDiskValue<V> value) {
        assert (this.codec != null);
        return this.codec.measureRecord(value.getValue());
    }

    public int getTypicalSerializedSize() {
        return 1024;
    }

    public void serialize(@NonNull OnDiskValue<V> value, @NonNull WritableSequentialData out) {
        assert (this.codec != null);
        try {
            this.codec.write(value.getValue(), out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public OnDiskValue<V> deserialize(@NonNull ReadableSequentialData in) {
        assert (this.codec != null);
        try {
            Object value = this.codec.parse(in);
            return new OnDiskValue<Object>(this.valueClassId, this.codec, value);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

