/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.disk;

import com.hedera.hapi.platform.state.StateValue;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.merkle.StateUtils;
import com.swirlds.state.merkle.disk.OnDiskSingletonHelper;
import com.swirlds.state.merkle.logging.StateLogger;
import com.swirlds.state.spi.WritableSingletonStateBase;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class OnDiskWritableSingletonState<T>
extends WritableSingletonStateBase<T> {
    @NonNull
    private final VirtualMap virtualMap;

    public OnDiskWritableSingletonState(@NonNull String serviceName, @NonNull String stateKey, @NonNull VirtualMap virtualMap) {
        super(serviceName, stateKey);
        this.virtualMap = Objects.requireNonNull(virtualMap);
    }

    protected T readFromDataSource() {
        Object value = OnDiskSingletonHelper.getFromStore(this.serviceName, this.stateKey, this.virtualMap);
        StateLogger.logSingletonRead(StateUtils.computeLabel(this.serviceName, this.stateKey), value);
        return value;
    }

    protected void putIntoDataSource(@NonNull T value) {
        Bytes keyBytes = StateUtils.getStateKeyForSingleton(this.serviceName, this.stateKey);
        StateValue stateValue = StateUtils.getStateValue(this.serviceName, this.stateKey, value);
        this.virtualMap.put(keyBytes, (Object)stateValue, StateValue.PROTOBUF);
        StateLogger.logSingletonWrite(StateUtils.computeLabel(this.serviceName, this.stateKey), value);
    }

    protected void removeFromDataSource() {
        StateValue stateValue = (StateValue)this.virtualMap.remove(StateUtils.getStateKeyForSingleton(this.serviceName, this.stateKey), StateValue.PROTOBUF);
        Object removedValue = stateValue != null ? stateValue.value().as() : null;
        StateLogger.logSingletonRemove(StateUtils.computeLabel(this.serviceName, this.stateKey), removedValue);
    }
}

