/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.fchashmap.internal;

import com.swirlds.common.FastCopyable;
import com.swirlds.common.utility.UnmodifiableIterator;
import com.swirlds.fchashmap.ModifiableValue;
import com.swirlds.fchashmap.internal.Mutation;
import com.swirlds.fchashmap.internal.PurgingEvent;
import com.swirlds.fchashmap.internal.UnPurgedMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.hiero.base.Copyable;
import org.hiero.base.ValueReference;
import org.hiero.base.concurrent.locks.AutoClosableLock;
import org.hiero.base.concurrent.locks.Locks;
import org.hiero.base.concurrent.locks.locked.Locked;

public class FCHashMapFamily<K, V> {
    private static final float LOAD_FACTOR = 0.75f;
    private static final int CONCURRENCY_LEVEL = 1024;
    private final Map<K, Mutation<V>> data;
    private final Map<Long, UnPurgedMap<K, V>> mapsNeedingPurging = new ConcurrentHashMap<Long, UnPurgedMap<K, V>>();
    private UnPurgedMap<K, V> mutableMap;
    private UnPurgedMap<K, V> oldestMap;
    private final AutoClosableLock deletionLock = Locks.createAutoLock();

    public FCHashMapFamily(int capacity) {
        this.data = new ConcurrentHashMap<K, Mutation<V>>(capacity, 0.75f, 1024);
        this.mutableMap = new UnPurgedMap(0L);
        this.oldestMap = this.mutableMap;
        this.mapsNeedingPurging.put(0L, this.mutableMap);
    }

    public Iterator<K> keyIterator() {
        return new UnmodifiableIterator(this.data.keySet().iterator());
    }

    public Map<K, Mutation<V>> getData() {
        return this.data;
    }

    public long copyMap() {
        if (this.mutableMap == null) {
            throw new IllegalStateException("The mutable copy of the map has been released, no further copies are permitted");
        }
        long nextVersion = this.mutableMap.getVersion() + 1L;
        UnPurgedMap<K, V> newMap = new UnPurgedMap<K, V>(nextVersion);
        this.mapsNeedingPurging.put(nextVersion, newMap);
        this.mutableMap.setNext(newMap);
        newMap.setPrevious(this.mutableMap);
        this.mutableMap = newMap;
        return nextVersion;
    }

    public V mutate(K key, V value, AtomicInteger size) {
        long version = this.mutableMap.getVersion();
        ValueReference originalValueReference = new ValueReference();
        ValueReference mutationToPurge = new ValueReference(null);
        this.data.compute(key, new MutateHandler(version, value, originalValueReference, mutationToPurge));
        Object originalValue = originalValueReference.getValue();
        if (originalValue == null && value != null) {
            size.getAndIncrement();
        } else if (originalValue != null && value == null) {
            size.getAndDecrement();
        }
        if (mutationToPurge.getValue() != null) {
            this.schedulePurging(key, (Mutation)mutationToPurge.getValue());
        }
        return (V)originalValue;
    }

    public Mutation<V> getMutation(long version, K key) {
        Mutation<V> mutation;
        for (mutation = this.data.get(key); mutation != null && mutation.getVersion() > version; mutation = mutation.getPrevious()) {
        }
        return mutation;
    }

    public ModifiableValue<V> getForModify(K key) {
        ValueReference original;
        long version = this.mutableMap.getVersion();
        Mutation<V> mutation = this.data.compute(key, new GetForModifyHandler(version, original = new ValueReference()));
        if (mutation == null || mutation.getValue() == null) {
            return null;
        }
        if (mutation.getValue() != original.getValue() && mutation.getPrevious() != null) {
            this.schedulePurging(key, mutation.getPrevious());
        }
        return new ModifiableValue<Object>(mutation.getValue(), original.getValue());
    }

    private void schedulePurging(K key, Mutation<V> mutation) {
        UnPurgedMap<K, V> purgingMap;
        for (purgingMap = this.mutableMap.getPrevious(); purgingMap != null && !purgingMap.schedulePurging(key, mutation); purgingMap = purgingMap.getPrevious()) {
        }
        if (purgingMap == null) {
            this.mutableMap.schedulePurging(key, mutation);
        }
    }

    private Map<Long, Long> buildNextUndeletedVersionMap() {
        HashMap<Long, Long> nextUndeletedVersionMap = new HashMap<Long, Long>();
        UnPurgedMap<K, V> nextUndeletedMap = this.mutableMap;
        for (long version = this.mutableMap.getVersion(); version >= this.oldestMap.getVersion(); --version) {
            UnPurgedMap<K, V> undeletedMap = this.mapsNeedingPurging.get(version);
            if (undeletedMap != null) {
                nextUndeletedMap = undeletedMap;
            }
            nextUndeletedVersionMap.put(version, nextUndeletedMap.getVersion());
        }
        return nextUndeletedVersionMap;
    }

    private void purgeMutation(long currentMapVersion, PurgingEvent<K, V> purgingEvent, Map<Long, Long> nextUndeletedVersionMap) {
        Mutation<V> target = purgingEvent.mutation();
        long nextUndeletedVersion = nextUndeletedVersionMap.getOrDefault(target.getVersion(), this.oldestMap.getVersion());
        this.data.compute(purgingEvent.key(), new PurgeMutationHandler<K, V>(target, nextUndeletedVersion, this.mapsNeedingPurging, currentMapVersion));
    }

    public void releaseMap(long mapVersion) {
        try (Locked locked = this.deletionLock.lock();){
            if (this.mutableMap == null || this.mutableMap.getVersion() == mapVersion) {
                this.mutableMap = null;
                return;
            }
            UnPurgedMap<K, V> mapToDelete = this.mapsNeedingPurging.remove(mapVersion);
            if (mapToDelete == null) {
                throw new IllegalStateException("Map with version " + mapVersion + " does not exist");
            }
            mapToDelete.markAsPurged();
            UnPurgedMap<K, V> previous = mapToDelete.getPrevious();
            UnPurgedMap<K, V> next = mapToDelete.getNext();
            if (previous != null) {
                previous.setNext(next);
            }
            if (next != null) {
                next.setPrevious(previous);
            }
            if (mapVersion == this.oldestMap.getVersion()) {
                this.oldestMap = this.oldestMap.getNext();
            }
            Map<Long, Long> nextUndeletedVersionMap = this.buildNextUndeletedVersionMap();
            for (PurgingEvent<K, V> event : mapToDelete) {
                this.purgeMutation(mapVersion, event, nextUndeletedVersionMap);
            }
        }
    }

    private record MutateHandler<K, V>(long version, V value, ValueReference<V> originalValueReference, ValueReference<Mutation<V>> mutationToPurge) implements BiFunction<K, Mutation<V>, Mutation<V>>
    {
        @Override
        public Mutation<V> apply(K key, Mutation<V> mutationHead) {
            Mutation<V> mutation;
            this.originalValueReference.setValue(mutationHead == null ? null : mutationHead.getValue());
            if (mutationHead != null && mutationHead.getVersion() == this.version) {
                mutation = mutationHead;
                mutation.setValue(this.value);
            } else {
                mutation = new Mutation<V>(this.version, this.value, mutationHead);
                if (mutationHead != null) {
                    this.mutationToPurge.setValue(mutationHead);
                }
            }
            if (this.value == null && mutation.getPrevious() == null) {
                return null;
            }
            return mutation;
        }
    }

    private record GetForModifyHandler<K, V>(long version, ValueReference<V> original) implements BiFunction<K, Mutation<V>, Mutation<V>>
    {
        @Override
        public Mutation<V> apply(K key, Mutation<V> mutationHead) {
            if (mutationHead == null) {
                return null;
            }
            this.original.setValue(mutationHead.getValue());
            if (mutationHead.getVersion() == this.version || mutationHead.getValue() == null) {
                return mutationHead;
            }
            return new Mutation<Copyable>(this.version, ((FastCopyable)mutationHead.getValue()).copy(), mutationHead);
        }
    }

    private record PurgeMutationHandler<K, V>(Mutation<V> target, long nextUndeletedVersion, Map<Long, UnPurgedMap<K, V>> mapsNeedingPurging, long currentMapVersion) implements BiFunction<K, Mutation<V>, Mutation<V>>
    {
        @Override
        public Mutation<V> apply(K key, Mutation<V> mutationHead) {
            Objects.requireNonNull(mutationHead, "Mutation head must not be null, can't purge mutations if there are no mutations");
            Mutation<V> next = this.target.getNext();
            Objects.requireNonNull(next, "Next should not be null. Mutation being purged is the latest mutation.");
            if (next.getVersion() <= this.nextUndeletedVersion) {
                next.setPrevious(this.target.getPrevious());
                if (this.target.getPrevious() != null) {
                    this.target.getPrevious().setNext(next);
                }
            } else if (!this.mapsNeedingPurging.get(this.nextUndeletedVersion).schedulePurging(key, this.target)) {
                throw new IllegalStateException("Unable to schedule purging for mutation with map version %d, this should not be possible, since map version %d is currently being purged and holds an exclusive lock.".formatted(this.nextUndeletedVersion, this.currentMapVersion));
            }
            if (mutationHead.getValue() == null && mutationHead.getPrevious() == null) {
                return null;
            }
            return mutationHead;
        }
    }
}

