/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.crypto.engine;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.Message;
import org.hiero.base.crypto.engine.CachingOperationProvider;

public class DigestProvider
extends CachingOperationProvider<Message, Void, byte[], MessageDigest, DigestType> {
    @NonNull
    protected byte[] compute(@NonNull byte[] msg) throws NoSuchAlgorithmException {
        return this.compute(msg, DigestType.SHA_384);
    }

    @Override
    @NonNull
    protected byte[] compute(@NonNull byte[] msg, @NonNull DigestType algorithmType) throws NoSuchAlgorithmException {
        if (msg == null) {
            throw new IllegalArgumentException("msg");
        }
        return this.compute(msg, 0, msg.length, algorithmType);
    }

    @NonNull
    private byte[] compute(@NonNull byte[] msg, int offset, int length, @NonNull DigestType algorithmType) throws NoSuchAlgorithmException {
        MessageDigest algorithm = (MessageDigest)this.loadAlgorithm(algorithmType);
        return this.compute(algorithm, msg, offset, length);
    }

    @Override
    @NonNull
    protected MessageDigest handleAlgorithmRequired(@NonNull DigestType algorithmType) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(algorithmType.algorithmName());
    }

    @Override
    @NonNull
    protected byte[] handleItem(@NonNull MessageDigest algorithm, @NonNull DigestType algorithmType, @NonNull Message item, @NonNull Void optionalData) {
        return this.compute(algorithm, item.getPayloadDirect(), item.getOffset(), item.getLength());
    }

    @NonNull
    private byte[] compute(@NonNull MessageDigest algorithm, @NonNull byte[] msg, int offset, int length) {
        algorithm.reset();
        algorithm.update(msg, offset, length);
        return algorithm.digest();
    }
}

