/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl.tipset;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.base.time.Time;
import com.swirlds.common.utility.throttle.RateLimitedLogger;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.Signature;
import org.hiero.consensus.crypto.PbjStreamHasher;
import org.hiero.consensus.event.creator.EventCreationConfig;
import org.hiero.consensus.event.creator.impl.EventCreator;
import org.hiero.consensus.event.creator.impl.tipset.ChildlessEventTracker;
import org.hiero.consensus.event.creator.impl.tipset.Tipset;
import org.hiero.consensus.event.creator.impl.tipset.TipsetAdvancementWeight;
import org.hiero.consensus.event.creator.impl.tipset.TipsetMetrics;
import org.hiero.consensus.event.creator.impl.tipset.TipsetTracker;
import org.hiero.consensus.event.creator.impl.tipset.TipsetWeightCalculator;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.event.UnsignedEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.quiescence.QuiescenceCommand;
import org.hiero.consensus.model.transaction.EventTransactionSupplier;
import org.hiero.consensus.roster.RosterUtils;

public class TipsetEventCreator
implements EventCreator {
    private static final Logger logger = LogManager.getLogger(TipsetEventCreator.class);
    private final Time time;
    private final SecureRandom random;
    private final HashSigner signer;
    private final NodeId selfId;
    private final TipsetTracker tipsetTracker;
    private final TipsetWeightCalculator tipsetWeightCalculator;
    private final ChildlessEventTracker childlessOtherEventTracker;
    private final EventTransactionSupplier transactionSupplier;
    private EventWindow eventWindow;
    private final Roster roster;
    private final int networkSize;
    private final double antiSelfishnessFactor;
    private final TipsetMetrics tipsetMetrics;
    private PlatformEvent lastSelfEvent;
    private final RateLimitedLogger zeroAdvancementWeightLogger;
    private final RateLimitedLogger noParentFoundLogger;
    private final PbjStreamHasher eventHasher;

    public TipsetEventCreator(@NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time, @NonNull SecureRandom random, @NonNull HashSigner signer, @NonNull Roster roster, @NonNull NodeId selfId, @NonNull EventTransactionSupplier transactionSupplier) {
        this.time = Objects.requireNonNull(time);
        this.random = Objects.requireNonNull(random);
        this.signer = Objects.requireNonNull(signer);
        this.selfId = Objects.requireNonNull(selfId);
        this.transactionSupplier = Objects.requireNonNull(transactionSupplier);
        this.roster = Objects.requireNonNull(roster);
        EventCreationConfig eventCreationConfig = (EventCreationConfig)configuration.getConfigData(EventCreationConfig.class);
        this.antiSelfishnessFactor = Math.max(1.0, eventCreationConfig.antiSelfishnessFactor());
        this.tipsetMetrics = new TipsetMetrics(metrics, roster);
        this.tipsetTracker = new TipsetTracker(time, selfId, roster);
        this.childlessOtherEventTracker = new ChildlessEventTracker();
        this.tipsetWeightCalculator = new TipsetWeightCalculator(configuration, time, roster, selfId, this.tipsetTracker, this.childlessOtherEventTracker);
        this.networkSize = roster.rosterEntries().size();
        this.zeroAdvancementWeightLogger = new RateLimitedLogger(logger, time, Duration.ofMinutes(1L));
        this.noParentFoundLogger = new RateLimitedLogger(logger, time, Duration.ofMinutes(1L));
        this.eventWindow = EventWindow.getGenesisEventWindow();
        this.eventHasher = new PbjStreamHasher();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void registerEvent(@NonNull PlatformEvent event) {
        if (this.eventWindow.isAncient(event)) {
            return;
        }
        NodeId eventCreator = event.getCreatorId();
        if (RosterUtils.getIndex((Roster)this.roster, (long)eventCreator.id()) == -1) {
            return;
        }
        boolean selfEvent = eventCreator.equals((Object)this.selfId);
        if (selfEvent) {
            if (this.lastSelfEvent != null && (!this.lastSelfEvent.hasNGen() || this.lastSelfEvent.getNGen() >= event.getNGen())) return;
            this.lastSelfEvent = event;
            this.childlessOtherEventTracker.registerSelfEventParents(event.getOtherParents());
            this.tipsetTracker.addSelfEvent(event.getDescriptor(), event.getAllParents());
            return;
        } else {
            this.tipsetTracker.addPeerEvent(event);
            this.childlessOtherEventTracker.addEvent(event);
        }
    }

    @Override
    public void setEventWindow(@NonNull EventWindow eventWindow) {
        this.eventWindow = Objects.requireNonNull(eventWindow);
        this.tipsetTracker.setEventWindow(eventWindow);
        this.childlessOtherEventTracker.pruneOldEvents(eventWindow);
    }

    @Override
    public void quiescenceCommand(@NonNull QuiescenceCommand quiescenceCommand) {
        throw new UnsupportedOperationException("Quiescence is not yet implemented");
    }

    @Override
    @Nullable
    public PlatformEvent maybeCreateEvent() {
        UnsignedEvent event = this.maybeCreateUnsignedEvent();
        if (event != null) {
            this.lastSelfEvent = this.signEvent(event);
            return this.lastSelfEvent;
        }
        return null;
    }

    @Nullable
    private UnsignedEvent maybeCreateUnsignedEvent() {
        if (this.networkSize == 1) {
            return this.createEventForSizeOneNetwork();
        }
        long selfishness = this.tipsetWeightCalculator.getMaxSelfishnessScore();
        this.tipsetMetrics.getSelfishnessMetric().update((double)selfishness);
        double beNiceChance = (double)(selfishness - 1L) / this.antiSelfishnessFactor;
        if (beNiceChance > 0.0 && this.random.nextDouble() < beNiceChance) {
            return this.createEventToReduceSelfishness();
        }
        return this.createEventByOptimizingAdvancementWeight();
    }

    private PlatformEvent signEvent(UnsignedEvent event) {
        Signature signature = this.signer.sign(event.getHash());
        return new PlatformEvent(event, signature.getBytes());
    }

    @NonNull
    private UnsignedEvent createEventForSizeOneNetwork() {
        return this.buildAndProcessEvent(this.lastSelfEvent);
    }

    @Nullable
    private UnsignedEvent createEventByOptimizingAdvancementWeight() {
        ArrayList<PlatformEvent> possibleOtherParents = new ArrayList<PlatformEvent>(this.childlessOtherEventTracker.getChildlessEvents());
        Collections.shuffle(possibleOtherParents, this.random);
        PlatformEvent bestOtherParent = null;
        TipsetAdvancementWeight bestAdvancementWeight = TipsetAdvancementWeight.ZERO_ADVANCEMENT_WEIGHT;
        for (PlatformEvent otherParent : possibleOtherParents) {
            TipsetAdvancementWeight advancementWeight;
            ArrayList<EventDescriptorWrapper> parents = new ArrayList<EventDescriptorWrapper>(2);
            parents.add(otherParent.getDescriptor());
            if (this.lastSelfEvent != null) {
                parents.add(this.lastSelfEvent.getDescriptor());
            }
            if (!(advancementWeight = this.tipsetWeightCalculator.getTheoreticalAdvancementWeight(parents)).isGreaterThan(bestAdvancementWeight)) continue;
            bestOtherParent = otherParent;
            bestAdvancementWeight = advancementWeight;
        }
        if (bestOtherParent == null) {
            if (!this.eventWindow.isGenesis() || this.lastSelfEvent != null) {
                return null;
            }
            return this.buildAndProcessEvent(null);
        }
        this.tipsetMetrics.getTipsetParentMetric(bestOtherParent.getCreatorId()).cycle();
        return this.buildAndProcessEvent(bestOtherParent);
    }

    @Nullable
    private UnsignedEvent createEventToReduceSelfishness() {
        Collection<PlatformEvent> possibleOtherParents = this.childlessOtherEventTracker.getChildlessEvents();
        ArrayList<PlatformEvent> ignoredNodes = new ArrayList<PlatformEvent>(possibleOtherParents.size());
        int selfishnessSum = 0;
        ArrayList<Integer> selfishnessScores = new ArrayList<Integer>(possibleOtherParents.size());
        for (PlatformEvent possibleIgnoredNode : possibleOtherParents) {
            int selfishness = this.tipsetWeightCalculator.getSelfishnessScoreForNode(possibleIgnoredNode.getCreatorId());
            ArrayList<EventDescriptorWrapper> theoreticalParents = new ArrayList<EventDescriptorWrapper>(2);
            theoreticalParents.add(possibleIgnoredNode.getDescriptor());
            if (this.lastSelfEvent == null) {
                throw new IllegalStateException("lastSelfEvent is null");
            }
            theoreticalParents.add(this.lastSelfEvent.getDescriptor());
            TipsetAdvancementWeight advancementWeight = this.tipsetWeightCalculator.getTheoreticalAdvancementWeight(theoreticalParents);
            if (selfishness <= 1) continue;
            if (advancementWeight.isNonZero()) {
                ignoredNodes.add(possibleIgnoredNode);
                selfishnessScores.add(selfishness);
                selfishnessSum += selfishness;
                continue;
            }
            this.zeroAdvancementWeightLogger.error(LogMarker.EXCEPTION.getMarker(), "selfishness score is {} but advancement score is zero for {}.\n{}", new Object[]{selfishness, possibleIgnoredNode, this});
        }
        if (ignoredNodes.isEmpty()) {
            this.noParentFoundLogger.error(LogMarker.EXCEPTION.getMarker(), "failed to locate eligible ignored node to use as a parent", new Object[0]);
            return null;
        }
        int choice = this.random.nextInt(selfishnessSum);
        int runningSum = 0;
        for (int i = 0; i < ignoredNodes.size(); ++i) {
            if (choice >= (runningSum += ((Integer)selfishnessScores.get(i)).intValue())) continue;
            PlatformEvent ignoredNode = (PlatformEvent)ignoredNodes.get(i);
            this.tipsetMetrics.getPityParentMetric(ignoredNode.getCreatorId()).cycle();
            return this.buildAndProcessEvent(ignoredNode);
        }
        throw new IllegalStateException("Failed to find an other parent");
    }

    private UnsignedEvent buildAndProcessEvent(@Nullable PlatformEvent otherParent) {
        EventDescriptorWrapper otherParentDescriptor = otherParent == null ? null : otherParent.getDescriptor();
        UnsignedEvent event = this.assembleEventObject(otherParentDescriptor);
        this.tipsetTracker.addSelfEvent(event.getDescriptor(), event.getMetadata().getAllParents());
        TipsetAdvancementWeight advancementWeight = this.tipsetWeightCalculator.addEventAndGetAdvancementWeight(event.getDescriptor());
        double weightRatio = (double)advancementWeight.advancementWeight() / (double)this.tipsetWeightCalculator.getMaximumPossibleAdvancementWeight();
        this.tipsetMetrics.getTipsetAdvancementMetric().update(weightRatio);
        if (otherParent != null) {
            this.childlessOtherEventTracker.registerSelfEventParents(List.of(otherParentDescriptor));
        }
        return event;
    }

    @NonNull
    private UnsignedEvent assembleEventObject(@Nullable EventDescriptorWrapper otherParent) {
        Instant now = this.time.now();
        Instant timeCreated = this.lastSelfEvent == null ? now : TipsetEventCreator.calculateNewEventCreationTime(now, this.lastSelfEvent.getTimeCreated(), this.lastSelfEvent.getTransactionCount());
        UnsignedEvent event = new UnsignedEvent(this.selfId, this.lastSelfEvent == null ? null : this.lastSelfEvent.getDescriptor(), otherParent == null ? Collections.emptyList() : Collections.singletonList(otherParent), this.eventWindow.newEventBirthRound(), timeCreated, this.transactionSupplier.getTransactionsForEvent(), this.random.nextLong(0L, this.roster.rosterEntries().size() + 1));
        this.eventHasher.hashUnsignedEvent(event);
        return event;
    }

    @Override
    public void clear() {
        this.tipsetTracker.clear();
        this.childlessOtherEventTracker.clear();
        this.tipsetWeightCalculator.clear();
        this.eventWindow = EventWindow.getGenesisEventWindow();
        this.lastSelfEvent = null;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Event window: ").append(this.tipsetTracker.getEventWindow()).append("\n");
        sb.append("Latest self event: ").append(this.lastSelfEvent).append("\n");
        sb.append(this.tipsetWeightCalculator);
        sb.append("Childless events:");
        Collection<PlatformEvent> childlessEvents = this.childlessOtherEventTracker.getChildlessEvents();
        if (childlessEvents.isEmpty()) {
            sb.append(" none\n");
        } else {
            sb.append("\n");
            for (PlatformEvent event : childlessEvents) {
                Tipset tipset = this.tipsetTracker.getTipset(event.getDescriptor());
                sb.append("  - ").append(event).append(" ").append(tipset).append("\n");
            }
        }
        return sb.toString();
    }

    @NonNull
    private static Instant calculateNewEventCreationTime(@NonNull Instant now, @NonNull Instant selfParentCreationTime, int selfParentTransactionCount) {
        int minimumIncrement = Math.max(1, selfParentTransactionCount);
        Instant minimumNextEventTime = selfParentCreationTime.plusNanos(minimumIncrement);
        if (now.isBefore(minimumNextEventTime)) {
            return minimumNextEventTime;
        }
        return now;
    }

    @FunctionalInterface
    public static interface HashSigner {
        public Signature sign(Hash var1);
    }
}

