/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.reconnect;

import com.swirlds.base.time.Time;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.UnableToReconnectPayload;
import com.swirlds.platform.system.SystemExitCode;
import com.swirlds.platform.system.SystemExitUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.node.NodeId;

public class ReconnectLearnerThrottle {
    private static final Logger logger = LogManager.getLogger(ReconnectLearnerThrottle.class);
    private final NodeId selfId;
    private final ReconnectConfig config;
    private final Time time;
    private final Instant startupTime;
    private int failedReconnectsInARow;

    public ReconnectLearnerThrottle(@NonNull Time time, @NonNull NodeId selfId, @NonNull ReconnectConfig config) {
        this.selfId = Objects.requireNonNull(selfId);
        this.config = Objects.requireNonNull(config);
        this.time = Objects.requireNonNull(time);
        this.failedReconnectsInARow = 0;
        this.startupTime = time.now();
    }

    @NonNull
    private Duration getTimeSinceStartup() {
        return Duration.between(this.startupTime, this.time.now());
    }

    public void successfulReconnect() {
        this.failedReconnectsInARow = 0;
    }

    public void handleFailedReconnect() {
        ++this.failedReconnectsInARow;
        this.killNodeIfThresholdMet();
    }

    private void killNodeIfThresholdMet() {
        if (this.failedReconnectsInARow >= this.config.maximumReconnectFailuresBeforeShutdown()) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Too many reconnect failures in a row, killing node");
            SystemExitUtils.exitSystem(SystemExitCode.RECONNECT_FAILURE);
        }
    }

    public void exitIfReconnectIsDisabled() {
        if (!this.config.active()) {
            logger.warn(LogMarker.STARTUP.getMarker(), () -> new UnableToReconnectPayload("Node has fallen behind, reconnect is disabled, will die", this.selfId.id()).toString());
            SystemExitUtils.exitSystem(SystemExitCode.BEHIND_RECONNECT_DISABLED);
        }
        if (this.config.reconnectWindowSeconds() >= 0 && (long)this.config.reconnectWindowSeconds() < this.getTimeSinceStartup().toSeconds()) {
            logger.warn(LogMarker.STARTUP.getMarker(), () -> new UnableToReconnectPayload("Node has fallen behind, reconnect is disabled outside of time window, will die", this.selfId.id()).toString());
            SystemExitUtils.exitSystem(SystemExitCode.BEHIND_RECONNECT_DISABLED);
        }
    }
}

