/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.migration;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.demo.migration.MigrationTestToolConsensusStateEventHandler;
import com.swirlds.demo.migration.MigrationTestingToolConfig;
import com.swirlds.demo.migration.MigrationTestingToolState;
import com.swirlds.demo.migration.TransactionGenerator;
import com.swirlds.fcqueue.FCQueueStatistics;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.ApplicationFinishedPayload;
import com.swirlds.merkle.map.MerkleMapMetrics;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.ParameterProvider;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.system.DefaultSwirldMain;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.test.fixtures.state.TestingAppStateInitializer;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.SignatureException;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.constructable.ClassConstructorPair;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterUtils;

public class MigrationTestingToolMain
extends DefaultSwirldMain<MigrationTestingToolState> {
    private static final Logger logger = LogManager.getLogger(MigrationTestingToolMain.class);
    private long seed;
    private int maximumTransactionsPerNode;
    private int transactionsCreated;
    private TransactionGenerator generator;
    private Platform platform;
    private int transPerSecToCreate = 1000;
    private double toCreate = 0.0;
    private long lastGenerateTime = System.nanoTime();
    public static final int SOFTWARE_VERSION = 65;
    public static final SemanticVersion PREVIOUS_SOFTWARE_VERSION;
    private static final SemanticVersion semanticVersion;

    public void init(@NonNull Platform platform, @NonNull NodeId selfId) {
        this.platform = platform;
        String[] parameters = ParameterProvider.getInstance().getParameters();
        logger.info(LogMarker.STARTUP.getMarker(), "Parsing arguments {}", (Object)parameters);
        if (parameters == null || parameters.length < 2) {
            throw new IllegalArgumentException("MigrationTestingTool requires at least 2 parameters: Seed(long), MaxTransactionsPerNode(int)");
        }
        this.seed = Long.parseLong(parameters[0]) + selfId.id();
        this.maximumTransactionsPerNode = Integer.parseInt(parameters[1]);
        this.transPerSecToCreate = parameters.length >= 3 ? Integer.parseInt(parameters[2]) : this.transPerSecToCreate;
        this.generator = new TransactionGenerator(this.seed);
        this.initAppStats();
    }

    public void run() {
        try {
            boolean isZeroWeight;
            logger.info(LogMarker.STARTUP.getMarker(), "MigrationTestingApp started handling {} transactions with seed {}", (Object)this.maximumTransactionsPerNode, (Object)this.seed);
            RosterEntry selfEntry = RosterUtils.getRosterEntry((Roster)this.platform.getRoster(), (long)this.platform.getSelfId().id());
            boolean bl = isZeroWeight = selfEntry.weight() == 0L;
            if (!isZeroWeight) {
                while (this.transactionsCreated < this.maximumTransactionsPerNode) {
                    try {
                        this.createTransactions();
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
            logger.info(LogMarker.STARTUP.getMarker(), () -> new ApplicationFinishedPayload("MigrationTestingApp finished handling transactions"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void initAppStats() {
        FCQueueStatistics.register((Metrics)this.platform.getContext().getMetrics());
        MerkleMapMetrics.register((Metrics)this.platform.getContext().getMetrics());
    }

    private void createTransactions() {
        long now = System.nanoTime();
        double tps = (double)this.transPerSecToCreate / (double)this.platform.getRoster().rosterEntries().size();
        this.toCreate += ((double)now - (double)this.lastGenerateTime) * 1.0E-9 * tps;
        this.lastGenerateTime = now;
        try {
            while (this.transactionsCreated < this.maximumTransactionsPerNode && !(this.toCreate < 1.0)) {
                byte[] transactionData = this.generator.generateTransaction();
                while (!this.getTransactionPool().submitApplicationTransaction(Bytes.wrap((byte[])transactionData))) {
                    Thread.sleep(100L);
                }
                ++this.transactionsCreated;
                this.toCreate -= 1.0;
            }
        }
        catch (InterruptedException | SignatureException ex) {
            throw new RuntimeException(ex);
        }
    }

    @NonNull
    public MigrationTestingToolState newStateRoot() {
        MigrationTestingToolState state = new MigrationTestingToolState();
        TestingAppStateInitializer.DEFAULT.initConsensusModuleStates((MerkleNodeState)state);
        return state;
    }

    public Function<VirtualMap, MigrationTestingToolState> stateRootFromVirtualMap() {
        throw new UnsupportedOperationException();
    }

    public ConsensusStateEventHandler<MigrationTestingToolState> newConsensusStateEvenHandler() {
        return new MigrationTestToolConsensusStateEventHandler();
    }

    @NonNull
    public List<Class<? extends Record>> getConfigDataTypes() {
        return List.of(MigrationTestingToolConfig.class);
    }

    public SemanticVersion getSemanticVersion() {
        return semanticVersion;
    }

    static {
        try {
            logger.info(LogMarker.STARTUP.getMarker(), "Registering MigrationTestingToolState with ConstructableRegistry");
            ConstructableRegistry constructableRegistry = ConstructableRegistry.getInstance();
            constructableRegistry.registerConstructable(new ClassConstructorPair(MigrationTestingToolState.class, MigrationTestingToolState::new));
            TestingAppStateInitializer.registerMerkleStateRootClassIds();
            logger.info(LogMarker.STARTUP.getMarker(), "MigrationTestingToolState is registered with ConstructableRegistry");
        }
        catch (ConstructableRegistryException e) {
            logger.error(LogMarker.STARTUP.getMarker(), "Failed to register MigrationTestingToolState", (Throwable)e);
            throw new RuntimeException(e);
        }
        PREVIOUS_SOFTWARE_VERSION = SemanticVersion.newBuilder().major(64).build();
        semanticVersion = SemanticVersion.newBuilder().major(65).build();
    }
}

