/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.merkle.map.internal;

import com.swirlds.common.test.fixtures.set.RandomAccessHashSet;
import com.swirlds.common.test.fixtures.set.RandomAccessSet;
import com.swirlds.demo.merkle.map.FCMConfig;
import com.swirlds.demo.merkle.map.FCMFamily;
import com.swirlds.demo.merkle.map.internal.ExpectedFCMFamily;
import com.swirlds.demo.platform.PAYLOAD_TYPE;
import com.swirlds.demo.platform.PayloadCfgSimple;
import com.swirlds.demo.platform.PayloadConfig;
import com.swirlds.demo.platform.nft.NftId;
import com.swirlds.merkle.test.fixtures.map.lifecycle.EntityType;
import com.swirlds.merkle.test.fixtures.map.lifecycle.ExpectedValue;
import com.swirlds.merkle.test.fixtures.map.lifecycle.LifecycleStatus;
import com.swirlds.merkle.test.fixtures.map.lifecycle.TransactionState;
import com.swirlds.merkle.test.fixtures.map.lifecycle.TransactionType;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import com.swirlds.merkle.test.fixtures.map.pta.MapValue;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;

public class DummyExpectedFCMFamily
implements ExpectedFCMFamily {
    private static final Random RANDOM = new SecureRandom();
    private final long nodeId;
    private int count;
    private int limit;
    private Map<MapKey, ExpectedValue> map;
    private final transient RandomAccessSet<NftId> availableNfts;

    public DummyExpectedFCMFamily(long nodeId) {
        this.nodeId = nodeId;
        this.count = 0;
        this.limit = 0;
        this.availableNfts = new RandomAccessHashSet();
    }

    @Override
    public void addEntityToExpectedMap(MapKey mapKey, ExpectedValue expectedValue) {
    }

    @Override
    public LifecycleStatus buildLifecycleStatusFromPayload(byte[] payload, PayloadConfig payloadConfig) {
        return null;
    }

    @Override
    public boolean entityHasBeenRemoved(MapKey mapKey) {
        return false;
    }

    @Override
    public Map<MapKey, ExpectedValue> getExpectedMap() {
        if (this.map == null) {
            this.map = new HashMap<MapKey, ExpectedValue>();
        }
        return this.map;
    }

    public void setExpectedMap(Map<MapKey, ExpectedValue> map) {
        this.map = map;
    }

    @Override
    public MapKey getMapKeyForFCMTx(TransactionType txType, EntityType entityType, boolean performOnDeleted, boolean operateEntitiesOfSameNode, int restrictedCount) {
        MapKey mapKey = new MapKey(this.nodeId, this.nodeId, (long)this.count++);
        if (this.count >= this.limit) {
            this.count = 0;
        }
        return mapKey;
    }

    @Override
    public Optional<NftId> getAnyNftId() {
        NftId nftId = (NftId)this.availableNfts.get(RANDOM);
        if (nftId == null) {
            return Optional.empty();
        }
        return Optional.of(nftId);
    }

    @Override
    public boolean doesTokenWithIdExist(NftId id) {
        return this.availableNfts.contains((Object)id);
    }

    @Override
    public void addNftId(NftId nftId) {
        this.availableNfts.add((Object)nftId);
    }

    @Override
    public boolean removeNftid(NftId nftId) {
        return this.availableNfts.remove((Object)nftId);
    }

    @Override
    public long getNextIdToCreate() {
        return this.limit++;
    }

    @Override
    public boolean insertMissingEntity(byte[] payload, ExpectedFCMFamily expectedFCMFamily, MapKey key, PayloadConfig payloadConfig) {
        return false;
    }

    @Override
    public void rebuildExpectedMap(FCMFamily fcmFamily, boolean isRestart, long timestamp) {
    }

    @Override
    public void setLatestHandledStatusForKey(MapKey mapKey, EntityType entityType, MapValue mapValue, TransactionState state, TransactionType transactionType, long timestamp, long nodeId, boolean error) {
        this.map.get(mapKey).setLatestHandledStatus(new LifecycleStatus(state, transactionType, timestamp, nodeId));
    }

    @Override
    public boolean shouldHandleForKeys(List<MapKey> mapKeys, TransactionType transactionType, PayloadCfgSimple payloadCfgSimple, EntityType entityType, long epochMillis, long originId) {
        return true;
    }

    @Override
    public void waitWhileExpectedMapEmpty(EntityType entityType, PAYLOAD_TYPE type) {
    }

    @Override
    public MapKey getMapKeyForQuery(EntityType entityType) throws IllegalArgumentException {
        return new MapKey(this.nodeId, this.nodeId, (long)this.count);
    }

    @Override
    public void setNodeId(long nodeId) {
    }

    @Override
    public void setFcmConfig(FCMConfig fcmConfig) {
    }

    @Override
    public void setWeightedNodeNum(int weightedNodeNum) {
    }
}

