/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.graph;

import com.swirlds.platform.test.fixtures.event.emitter.StandardEventEmitter;
import com.swirlds.platform.test.fixtures.graph.OtherParentMatrixFactory;
import java.util.List;

public class SplitForkGraphCreator {
    public static void createSplitForkConditions(StandardEventEmitter generator, int creatorToFork, int otherParent, int numCommonEvents, int numNetworkNodes) {
        SplitForkGraphCreator.forceNextCreator(generator, creatorToFork, numCommonEvents);
        SplitForkGraphCreator.forceNextOtherParent(generator, creatorToFork, otherParent, numCommonEvents, numNetworkNodes);
    }

    private static void forceNextCreator(StandardEventEmitter emitter, int creatorToFork, int numCommonEvents) {
        int numberOfSources = emitter.getGraphGenerator().getNumberOfSources();
        for (int i = 0; i < numberOfSources; ++i) {
            boolean sourceIsCreatorToFork = i == creatorToFork;
            emitter.getGraphGenerator().getSourceByIndex(i).setNewEventWeight((r, index, prev) -> {
                if (index < (long)numCommonEvents) {
                    return 1.0;
                }
                if (index == (long)numCommonEvents && sourceIsCreatorToFork) {
                    return 1.0;
                }
                if (index > (long)numCommonEvents) {
                    return 1.0;
                }
                return 0.0;
            });
        }
    }

    private static void forceNextOtherParent(StandardEventEmitter emitter, int creatorToShun, int nextOtherParent, int numCommonEvents, int numNetworkNodes) {
        int numSources = emitter.getGraphGenerator().getNumberOfSources();
        List<List<Double>> balancedMatrix = OtherParentMatrixFactory.createBalancedOtherParentMatrix(numNetworkNodes);
        List<List<Double>> forcedOtherParentMatrix = OtherParentMatrixFactory.createForcedOtherParentMatrix(numSources, nextOtherParent);
        List<List<Double>> shunnedOtherParentMatrix = OtherParentMatrixFactory.createShunnedNodeOtherParentAffinityMatrix(numSources, creatorToShun);
        emitter.getGraphGenerator().setOtherParentAffinity((r, eventIndex, previousValue) -> {
            if (eventIndex < (long)numCommonEvents) {
                return balancedMatrix;
            }
            if (eventIndex == (long)numCommonEvents) {
                return forcedOtherParentMatrix;
            }
            return shunnedOtherParentMatrix;
        });
    }
}

