/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.virtualmerkle.map.smartcontracts.bytecode;

import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.virtualmap.VirtualKey;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public final class SmartContractByteCodeMapKey
implements VirtualKey {
    private static final long CLASS_ID = -4865583269236300395L;
    private long contractId;

    public SmartContractByteCodeMapKey() {
        this(-1L);
    }

    public SmartContractByteCodeMapKey(long contractId) {
        this.contractId = contractId;
    }

    public static SmartContractByteCodeMapKey fromBytes(Bytes bytes) {
        return new SmartContractByteCodeMapKey(bytes.getLong(0L));
    }

    public Bytes toBytes() {
        byte[] bytes = new byte[8];
        ByteBuffer.wrap(bytes).putLong(this.contractId);
        return Bytes.wrap((byte[])bytes);
    }

    static int getSizeInBytes() {
        return 8;
    }

    public long getClassId() {
        return -4865583269236300395L;
    }

    public int getVersion() {
        return 1;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.contractId);
    }

    public void serialize(WritableSequentialData out) {
        out.writeLong(this.contractId);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.contractId = in.readLong();
    }

    void deserialize(ReadableSequentialData in) {
        this.contractId = in.readLong();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SmartContractByteCodeMapKey that = (SmartContractByteCodeMapKey)other;
        return this.contractId == that.contractId;
    }

    boolean equals(BufferedData buffer) {
        return buffer.readLong() == this.contractId;
    }

    public int hashCode() {
        return Objects.hash(this.contractId);
    }

    public String toString() {
        return "SmartContractByteCodeMapKey{contractId=" + this.contractId + "}";
    }

    public long getContractId() {
        return this.contractId;
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

