/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base.time;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Objects;

public final class NanoClock
extends Clock {
    private final Clock clock;
    private final long initialNanos;
    private final Instant initialInstant;

    public NanoClock() {
        this(Clock.systemUTC());
    }

    public NanoClock(@NonNull Clock clock) {
        this.clock = Objects.requireNonNull(clock, "clock must not be null");
        this.initialInstant = clock.instant();
        this.initialNanos = NanoClock.getSystemNanos();
    }

    @Override
    @NonNull
    public ZoneId getZone() {
        return this.clock.getZone();
    }

    @Override
    @NonNull
    public Instant instant() {
        return this.initialInstant.plusNanos(NanoClock.getSystemNanos() - this.initialNanos);
    }

    @Override
    @NonNull
    public Clock withZone(@NonNull ZoneId zone) {
        return new NanoClock(this.clock.withZone(Objects.requireNonNull(zone, "zone must not be null")));
    }

    private static long getSystemNanos() {
        return System.nanoTime();
    }
}

