/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.consensus.framework.validation;

import com.swirlds.platform.test.fixtures.consensus.framework.validation.ConsensusRoundComparisonValidation;
import com.swirlds.platform.test.fixtures.consensus.framework.validation.ConsensusRoundConsistencyValidation;
import com.swirlds.platform.test.fixtures.consensus.framework.validation.RoundAncientThresholdIncreasesValidation;
import com.swirlds.platform.test.fixtures.consensus.framework.validation.RoundInternalConsistencyValidation;
import com.swirlds.platform.test.fixtures.consensus.framework.validation.RoundInternalEqualityValidation;
import com.swirlds.platform.test.fixtures.consensus.framework.validation.RoundTimestampCheckerValidation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.hiero.consensus.model.hashgraph.ConsensusRound;

public class ConsensusRoundValidator {
    private static final Set<ConsensusRoundComparisonValidation> validationsForDifferentNodes = Set.of(RoundInternalEqualityValidation.INSTANCE);
    private static final Set<ConsensusRoundConsistencyValidation> validationsForSameNode = Set.of(RoundInternalConsistencyValidation.INSTANCE, RoundTimestampCheckerValidation.INSTANCE, RoundAncientThresholdIncreasesValidation.INSTANCE);

    private ConsensusRoundValidator() {
    }

    public static void validate(@NonNull List<ConsensusRound> rounds1, @NonNull List<ConsensusRound> rounds2) {
        ((ListAssert)Assertions.assertThat(rounds1).withFailMessage(String.format("The number of consensus rounds is not the same.first argument has %d rounds, second has %d rounds", rounds1.size(), rounds2.size()), new Object[0])).hasSameSizeAs(rounds2);
        for (ConsensusRoundComparisonValidation validation : validationsForDifferentNodes) {
            int n = rounds1.size();
            for (int i = 0; i < n; ++i) {
                validation.validate(rounds1.get(i), rounds2.get(i));
            }
        }
    }

    public static void validate(@NonNull ConsensusRound round1, @NonNull ConsensusRound round2) {
        ConsensusRoundValidator.validate(List.of(round1), List.of(round2));
    }

    public static void validate(@NonNull List<ConsensusRound> rounds) {
        for (ConsensusRoundConsistencyValidation validation : validationsForSameNode) {
            validation.validate(rounds);
        }
    }
}

