/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gossip;

import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.platform.system.status.StatusActionSubmitter;
import com.swirlds.platform.system.status.actions.FallenBehindAction;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hiero.consensus.gossip.FallenBehindManager;
import org.hiero.consensus.model.node.NodeId;

public class FallenBehindManagerImpl
implements FallenBehindManager {
    private int numNeighbors;
    private final Set<NodeId> reportFallenBehind = new HashSet<NodeId>();
    private final StatusActionSubmitter statusActionSubmitter;
    private final ReconnectConfig config;
    private boolean previouslyFallenBehind;

    public FallenBehindManagerImpl(@NonNull NodeId selfId, int numNeighbors, @NonNull StatusActionSubmitter statusActionSubmitter, @NonNull ReconnectConfig config) {
        Objects.requireNonNull(selfId, "selfId");
        this.numNeighbors = numNeighbors;
        this.statusActionSubmitter = Objects.requireNonNull(statusActionSubmitter);
        this.config = Objects.requireNonNull(config, "config must not be null");
    }

    public synchronized void reportFallenBehind(@NonNull NodeId id) {
        if (this.reportFallenBehind.add(id)) {
            this.checkAndNotifyFallingBehind();
        }
    }

    public synchronized void clearFallenBehind(@NonNull NodeId id) {
        this.reportFallenBehind.remove(id);
    }

    private void checkAndNotifyFallingBehind() {
        if (!this.previouslyFallenBehind && this.hasFallenBehind()) {
            this.statusActionSubmitter.submitStatusAction(new FallenBehindAction());
            this.previouslyFallenBehind = true;
        }
    }

    public synchronized void addRemovePeers(@NonNull Set<NodeId> added, @NonNull Set<NodeId> removed) {
        Objects.requireNonNull(added);
        Objects.requireNonNull(removed);
        this.numNeighbors += added.size() - removed.size();
        for (NodeId nodeId : removed) {
            if (!this.reportFallenBehind.contains(nodeId) || added.contains(nodeId)) continue;
            this.reportFallenBehind.remove(nodeId);
        }
        this.checkAndNotifyFallingBehind();
    }

    public synchronized boolean hasFallenBehind() {
        return (double)this.numNeighbors * this.config.fallenBehindThreshold() < (double)this.reportFallenBehind.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldReconnectFrom(@NonNull NodeId peerId) {
        if (!this.hasFallenBehind()) {
            return false;
        }
        FallenBehindManagerImpl fallenBehindManagerImpl = this;
        synchronized (fallenBehindManagerImpl) {
            return this.reportFallenBehind.contains(peerId);
        }
    }

    public synchronized void resetFallenBehind() {
        this.reportFallenBehind.clear();
        this.previouslyFallenBehind = false;
    }

    public synchronized int numReportedFallenBehind() {
        return this.reportFallenBehind.size();
    }
}

