/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.files;

import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkledb.FileStatisticAware;
import com.swirlds.merkledb.KeyRange;
import com.swirlds.merkledb.Snapshotable;
import com.swirlds.merkledb.collections.LongList;
import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.merkledb.files.DataFileCollection;
import com.swirlds.merkledb.files.DataFileReader;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LongSummaryStatistics;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MemoryIndexDiskKeyValueStore
implements AutoCloseable,
Snapshotable,
FileStatisticAware {
    private static final Logger logger = LogManager.getLogger(MemoryIndexDiskKeyValueStore.class);
    private final LongList index;
    final DataFileCollection fileCollection;
    private final String storeName;

    public MemoryIndexDiskKeyValueStore(MerkleDbConfig config, Path storeDir, String storeName, String legacyStoreName, DataFileCollection.LoadedDataCallback loadedDataCallback, LongList keyToDiskLocationIndex) throws IOException {
        this.storeName = storeName;
        this.index = keyToDiskLocationIndex;
        Files.createDirectories(storeDir, new FileAttribute[0]);
        this.fileCollection = new DataFileCollection(config, storeDir, storeName, legacyStoreName, loadedDataCallback);
    }

    public void updateValidKeyRange(long min, long max) {
        this.index.updateValidRange(min, max);
    }

    public void startWriting() throws IOException {
        this.fileCollection.startWriting();
    }

    public void put(long key, Consumer<BufferedData> dataItemWriter, int dataItemSize) throws IOException {
        long dataLocation = this.fileCollection.storeDataItem(dataItemWriter, dataItemSize);
        this.index.put(key, dataLocation);
    }

    @Nullable
    public DataFileReader endWriting() throws IOException {
        long currentMinValidKey = this.index.getMinValidIndex();
        long currentMaxValidKey = this.index.getMaxValidIndex();
        this.fileCollection.updateValidKeyRange(currentMinValidKey, currentMaxValidKey);
        DataFileReader dataFileReader = this.fileCollection.endWriting();
        logger.info(LogMarker.MERKLE_DB.getMarker(), "{} Ended writing, newFile={}, numOfFiles={}, minimumValidKey={}, maximumValidKey={}", (Object)this.storeName, (Object)dataFileReader.getIndex(), (Object)this.fileCollection.getNumOfFiles(), (Object)currentMinValidKey, (Object)currentMaxValidKey);
        return dataFileReader;
    }

    private boolean checkKeyInRange(long key) {
        KeyRange keyRange = this.fileCollection.getValidKeyRange();
        if (!keyRange.withinRange(key)) {
            if (key != 0L) {
                logger.trace(LogMarker.MERKLE_DB.getMarker(), "Key [{}] is outside valid key range of {}", (Object)key, (Object)keyRange);
            }
            return false;
        }
        return true;
    }

    public BufferedData get(long key) throws IOException {
        if (!this.checkKeyInRange(key)) {
            return null;
        }
        return this.fileCollection.readDataItemUsingIndex(this.index, key);
    }

    @Override
    public void close() throws IOException {
        this.fileCollection.close();
    }

    @Override
    public void snapshot(Path snapshotDirectory) throws IOException {
        this.fileCollection.snapshot(snapshotDirectory);
    }

    @Override
    public LongSummaryStatistics getFilesSizeStatistics() {
        return this.fileCollection.getFilesSizeStatistics();
    }

    public DataFileCollection getFileCollection() {
        return this.fileCollection;
    }
}

