/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.utility;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;

public class ThresholdLimitingHandler<E> {
    private final long threshold;
    private final Function<E, String> keyExtractor;
    private final Map<String, Long> state;

    public ThresholdLimitingHandler(long threshold) {
        this(threshold, ThresholdLimitingHandler::resolveElementClass);
    }

    public ThresholdLimitingHandler(long threshold, Function<E, String> keyExtractor) {
        this.threshold = threshold;
        this.keyExtractor = keyExtractor;
        this.state = new ConcurrentHashMap<String, Long>();
    }

    public void handle(E element, Consumer<E> callback) {
        if (element == null) {
            throw new IllegalArgumentException("The element argument may not be a null value");
        }
        String key = this.keyExtractor.apply(element);
        long counter = this.state.compute(key, (k, oldValue) -> {
            if (oldValue == null) {
                return 1L;
            }
            return oldValue + 1L;
        });
        if (counter <= this.threshold && callback != null) {
            callback.accept(element);
        }
    }

    public long getCurrentThreshold(E element) {
        if (element == null) {
            throw new IllegalArgumentException("The element argument may not be a null value");
        }
        String key = this.keyExtractor.apply(element);
        return this.state.getOrDefault(key, 0L);
    }

    public void reset() {
        this.state.clear();
    }

    public void reset(E element) {
        String key = this.keyExtractor.apply(element);
        this.state.remove(key);
    }

    private static <E> String resolveElementClass(E element) {
        Class<?> elClass = element != null ? element.getClass() : null;
        return String.valueOf(elClass);
    }
}

